/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.lookup;

import com.neovisionaries.i18n.CountryCode;
import java.net.MalformedURLException;
import java.net.URL;
import me.tobiadeyinka.itunessearch.exceptions.ItunesSearchException;
import me.tobiadeyinka.itunessearch.exceptions.NoMatchFoundException;
import me.tobiadeyinka.itunessearch.networking.NetworkUtils;
import org.json.JSONArray;
import org.json.JSONObject;

abstract class Lookup {
    protected static final String BASE_LOOKUP_URL = "https://itunes.apple.com/lookup?";
    protected static final int DEFAULT_LIMIT = 100;
    protected static final CountryCode DEFAULT_COUNTRY = CountryCode.US;

    Lookup() {
    }

    protected static JSONObject getById(long id) throws NoMatchFoundException {
        String urlString = String.format("%sid=%s", BASE_LOOKUP_URL, id);
        JSONObject response = Lookup.executeQuery(urlString);
        JSONArray responseJSONArray = response.getJSONArray("results");
        if (responseJSONArray.length() == 0) {
            throw new NoMatchFoundException("No item matches the given id");
        }
        return response;
    }

    protected static JSONObject executeQuery(String urlString) {
        JSONObject response = null;
        try {
            URL url = new URL(urlString);
            response = NetworkUtils.executeQuery(url);
        }
        catch (MalformedURLException | ItunesSearchException e) {
            e.printStackTrace();
        }
        return response;
    }
}

