/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.lookup;

import com.neovisionaries.i18n.CountryCode;
import me.tobiadeyinka.itunessearch.exceptions.NoMatchFoundException;
import me.tobiadeyinka.itunessearch.lookup.Lookup;
import org.json.JSONObject;

public class MovieLookup
extends Lookup {
    public static JSONObject getMovieById(long id) throws NoMatchFoundException {
        return MovieLookup.getById(id);
    }

    public static JSONObject topMovies() {
        return MovieLookup.topMovies(100);
    }

    public static JSONObject topMovies(int limit) {
        return MovieLookup.queryMovieList(MovieList.TOP_MOVIES, DEFAULT_COUNTRY, limit);
    }

    public static JSONObject topMovies(CountryCode countryCode) {
        return MovieLookup.queryMovieList(MovieList.TOP_MOVIES, countryCode, 100);
    }

    public static JSONObject topMovies(CountryCode countryCode, int limit) {
        return MovieLookup.queryMovieList(MovieList.TOP_MOVIES, countryCode, limit);
    }

    private static JSONObject queryMovieList(MovieList list, CountryCode countryCode, int limit) {
        return MovieLookup.executeQuery(String.format("https://rss.itunes.apple.com/api/v1/%s/movies/%s/all/%s/explicit.json", countryCode.getAlpha2(), list.urlKey, limit));
    }

    private static enum MovieList {
        TOP_MOVIES("top-movies");

        String urlKey;

        private MovieList(String urlKey) {
            this.urlKey = urlKey;
        }
    }
}

