/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.lookup;

import com.neovisionaries.i18n.CountryCode;
import me.tobiadeyinka.itunessearch.exceptions.NoMatchFoundException;
import me.tobiadeyinka.itunessearch.lookup.Lookup;
import org.json.JSONObject;

public abstract class MusicLookup
extends Lookup {
    public static JSONObject getSongById(long id) throws NoMatchFoundException {
        return MusicLookup.getById(id);
    }

    public static JSONObject topSongs() {
        return MusicLookup.topSongs(100);
    }

    public static JSONObject topSongs(int limit) {
        return MusicLookup.querySongList(MusicList.TOP_SONGS, DEFAULT_COUNTRY, limit);
    }

    public static JSONObject topSongs(CountryCode countryCode) {
        return MusicLookup.querySongList(MusicList.TOP_SONGS, countryCode, 100);
    }

    public static JSONObject topSongs(CountryCode countryCode, int limit) {
        return MusicLookup.querySongList(MusicList.TOP_SONGS, countryCode, limit);
    }

    public static JSONObject hotTracks() {
        return MusicLookup.hotTracks(100);
    }

    public static JSONObject hotTracks(int limit) {
        return MusicLookup.querySongList(MusicList.HOT_TRACKS, DEFAULT_COUNTRY, limit);
    }

    public static JSONObject hotTracks(CountryCode countryCode) {
        return MusicLookup.querySongList(MusicList.HOT_TRACKS, countryCode, 100);
    }

    public static JSONObject hotTracks(CountryCode countryCode, int limit) {
        return MusicLookup.querySongList(MusicList.HOT_TRACKS, countryCode, limit);
    }

    public static JSONObject newMusic() {
        return MusicLookup.newMusic(100);
    }

    public static JSONObject newMusic(int limit) {
        return MusicLookup.querySongList(MusicList.NEW_MUSIC, DEFAULT_COUNTRY, limit);
    }

    public static JSONObject newMusic(CountryCode countryCode) {
        return MusicLookup.querySongList(MusicList.NEW_MUSIC, countryCode, 100);
    }

    public static JSONObject newMusic(CountryCode countryCode, int limit) {
        return MusicLookup.querySongList(MusicList.NEW_MUSIC, countryCode, limit);
    }

    public static JSONObject recentReleases() {
        return MusicLookup.recentReleases(100);
    }

    public static JSONObject recentReleases(int limit) {
        return MusicLookup.querySongList(MusicList.RECENT_RELEASES, DEFAULT_COUNTRY, limit);
    }

    public static JSONObject recentReleases(CountryCode countryCode) {
        return MusicLookup.querySongList(MusicList.RECENT_RELEASES, countryCode, 100);
    }

    public static JSONObject recentReleases(CountryCode countryCode, int limit) {
        return MusicLookup.querySongList(MusicList.RECENT_RELEASES, countryCode, limit);
    }

    public static JSONObject getAlbumById(long id) throws NoMatchFoundException {
        return MusicLookup.getById(id);
    }

    public static JSONObject topAlbums() {
        return MusicLookup.topAlbums(100);
    }

    public static JSONObject topAlbums(int limit) {
        return MusicLookup.querySongList(MusicList.TOP_ALBUMS, DEFAULT_COUNTRY, limit);
    }

    public static JSONObject topAlbums(CountryCode countryCode) {
        return MusicLookup.querySongList(MusicList.TOP_ALBUMS, countryCode, 100);
    }

    public static JSONObject topAlbums(CountryCode countryCode, int limit) {
        return MusicLookup.querySongList(MusicList.TOP_ALBUMS, countryCode, limit);
    }

    private static JSONObject querySongList(MusicList list, CountryCode countryCode, int limit) {
        return MusicLookup.executeQuery(String.format("https://rss.itunes.apple.com/api/v1/%s/itunes-music/%s/all/%s/explicit.json", countryCode.getAlpha2(), list.urlKey, limit));
    }

    private static enum MusicList {
        TOP_SONGS("top-songs"),
        NEW_MUSIC("new-music"),
        TOP_ALBUMS("top-albums"),
        HOT_TRACKS("hot-tracks"),
        RECENT_RELEASES("recent-releases");

        String urlKey;

        private MusicList(String urlKey) {
            this.urlKey = urlKey;
        }
    }
}

