/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.lookup;

import com.neovisionaries.i18n.CountryCode;
import me.tobiadeyinka.itunessearch.exceptions.NoMatchFoundException;
import me.tobiadeyinka.itunessearch.lookup.Lookup;
import org.json.JSONObject;

public abstract class PodcastLookup
extends Lookup {
    public static JSONObject getPodcastById(long id) throws NoMatchFoundException {
        return PodcastLookup.getById(id);
    }

    public static JSONObject topPodcasts() {
        return PodcastLookup.topPodcasts(100);
    }

    public static JSONObject topPodcasts(int limit) {
        return PodcastLookup.queryTopPodcasts(DEFAULT_COUNTRY, limit);
    }

    public static JSONObject topPodcasts(CountryCode countryCode) {
        return PodcastLookup.queryTopPodcasts(countryCode, 100);
    }

    public static JSONObject topPodcasts(CountryCode countryCode, int limit) {
        return PodcastLookup.queryTopPodcasts(countryCode, limit);
    }

    public static JSONObject comedyPodcasts() {
        return PodcastLookup.getPodcastGenre(PodcastGenre.COMEDY, 100);
    }

    public static JSONObject comedyPodcasts(int limit) {
        return PodcastLookup.getPodcastGenre(PodcastGenre.COMEDY, limit);
    }

    public static JSONObject newsAndPoliticsPodcasts() {
        return PodcastLookup.getPodcastGenre(PodcastGenre.NEWS_AND_POLITICS, 100);
    }

    public static JSONObject newsAndPoliticsPodcasts(int limit) {
        return PodcastLookup.getPodcastGenre(PodcastGenre.NEWS_AND_POLITICS, limit);
    }

    public static JSONObject societyAndCulturePodcasts() {
        return PodcastLookup.getPodcastGenre(PodcastGenre.NEWS_AND_POLITICS, 100);
    }

    public static JSONObject societyAndCulturePodcasts(int limit) {
        return PodcastLookup.getPodcastGenre(PodcastGenre.SOCIETY_AND_CULTURE, limit);
    }

    private static JSONObject getPodcastGenre(PodcastGenre genre, int limit) {
        return PodcastLookup.executeQuery(String.format("https://itunes.apple.com/search?term=podcast&limit=%s&genreId=%s", limit, genre.id));
    }

    private static JSONObject queryTopPodcasts(CountryCode countryCode, int limit) {
        return PodcastLookup.executeQuery(String.format("https://rss.itunes.apple.com/api/v1/%s/podcasts/top-podcasts/all/%s/explicit.json", countryCode.getAlpha2(), limit));
    }

    private static enum PodcastGenre {
        COMEDY(1303),
        NEWS_AND_POLITICS(1311),
        SOCIETY_AND_CULTURE(1324);

        int id;

        private PodcastGenre(int id) {
            this.id = id;
        }
    }
}

