/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.networking;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.Scanner;
import me.tobiadeyinka.itunessearch.exceptions.NetworkCommunicationException;
import org.json.JSONObject;

public abstract class NetworkUtils {
    public static JSONObject executeQuery(URL url) {
        try {
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            return new JSONObject(Objects.requireNonNull(NetworkUtils.query(new URL(uri.toASCIIString()))));
        }
        catch (IOException | URISyntaxException e) {
            throw new NetworkCommunicationException(String.format("Error while executing query: %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String query(URL url) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        try {
            InputStream inputStream = urlConnection.getInputStream();
            Scanner scanner = new Scanner(inputStream);
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : null;
            return string;
        }
        finally {
            urlConnection.disconnect();
        }
    }
}

