/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.entities.MediaAttribute;
import me.tobiadeyinka.itunessearch.entities.MediaSearchReturnType;
import me.tobiadeyinka.itunessearch.search.Search;

public class MediaSearch
extends Search<MediaSearch> {
    private MediaAttribute attribute = MediaAttribute.ALL;
    private MediaSearchReturnType returnType = MediaSearchReturnType.DEFAULT;

    public MediaSearch() {
        super(ItunesMedia.ALL);
    }

    public MediaSearch inAttribute(MediaAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public MediaSearch andReturn(MediaSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public MediaAttribute getAttribute() {
        return this.attribute;
    }

    public MediaSearchReturnType getReturnType() {
        return this.returnType;
    }
}

