/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.entities.MusicVideoAttribute;
import me.tobiadeyinka.itunessearch.entities.MusicVideoSearchReturnType;
import me.tobiadeyinka.itunessearch.search.Search;

public class MusicVideoSearch
extends Search<MusicVideoSearch> {
    private MusicVideoAttribute attribute = MusicVideoAttribute.ALL;
    private MusicVideoSearchReturnType returnType = MusicVideoSearchReturnType.DEFAULT;

    public MusicVideoSearch() {
        super(ItunesMedia.MUSIC_VIDEO);
    }

    public MusicVideoSearch inAttribute(MusicVideoAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public MusicVideoSearch andReturn(MusicVideoSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public MusicVideoAttribute getAttribute() {
        return this.attribute;
    }

    public MusicVideoSearchReturnType getReturnType() {
        return this.returnType;
    }
}

