/*
 * Decompiled with CFR 0.152.
 */
package me.tobiadeyinka.itunessearch.search;

import me.tobiadeyinka.itunessearch.entities.ItunesMedia;
import me.tobiadeyinka.itunessearch.entities.SoftwareAttribute;
import me.tobiadeyinka.itunessearch.entities.SoftwareSearchReturnType;
import me.tobiadeyinka.itunessearch.search.Search;

public class SoftwareSearch
extends Search<SoftwareSearch> {
    private SoftwareAttribute attribute = SoftwareAttribute.ALL;
    private SoftwareSearchReturnType returnType = SoftwareSearchReturnType.SOFTWARE;

    public SoftwareSearch() {
        super(ItunesMedia.SOFTWARE);
    }

    public SoftwareSearch inAttribute(SoftwareAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public SoftwareSearch andReturn(SoftwareSearchReturnType returnType) {
        this.returnType = returnType;
        return this;
    }

    @Override
    protected String constructUrlString() {
        return "https://itunes.apple.com/search?term=" + this.searchTerm + "&country=" + this.countryCode.getAlpha2() + "&media=" + this.media.getParameterValue() + "&entity=" + this.returnType.getParameterValue() + "&attributeType=" + this.attribute.getParameterValue() + "&limit=" + this.limit + "&lang=" + this.returnLanguage.getCodeName() + "&version=" + this.apiVersion + "&explicit=" + (this.allowExplicit ? "Yes" : "No");
    }

    public SoftwareAttribute getAttribute() {
        return this.attribute;
    }

    public SoftwareSearchReturnType getReturnType() {
        return this.returnType;
    }
}

