/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.bean.copier.provider;

import java.lang.reflect.Type;
import java.util.Map;
import me.venise.core.bean.copier.ValueProvider;
import me.venise.core.convert.Convert;
import me.venise.core.map.CaseInsensitiveMap;
import me.venise.core.util.StringUtil;

public class MapValueProvider
implements ValueProvider<String> {
    private final Map<?, ?> map;
    private final boolean ignoreError;

    public MapValueProvider(Map<?, ?> map, boolean ignoreCase) {
        this(map, ignoreCase, false);
    }

    public MapValueProvider(Map<?, ?> map, boolean ignoreCase, boolean ignoreError) {
        this.map = false == ignoreCase || map instanceof CaseInsensitiveMap ? map : new CaseInsensitiveMap(map);
        this.ignoreError = ignoreError;
    }

    @Override
    public Object value(String key, Type valueType) {
        String key1 = this.getKey(key, valueType);
        if (null == key1) {
            return null;
        }
        Object value = this.map.get(key1);
        return Convert.convertWithCheck(valueType, value, null, this.ignoreError);
    }

    @Override
    public boolean containsKey(String key) {
        return null != this.getKey(key, null);
    }

    private String getKey(String key, Type valueType) {
        if (this.map.containsKey(key)) {
            return key;
        }
        String customKey = StringUtil.toUnderlineCase(key);
        if (this.map.containsKey(customKey)) {
            return customKey;
        }
        if (null == valueType || Boolean.class == valueType || Boolean.TYPE == valueType) {
            customKey = StringUtil.upperFirstAndAddPre(key, "is");
            if (this.map.containsKey(customKey)) {
                return customKey;
            }
            if (this.map.containsKey(customKey = StringUtil.toUnderlineCase(customKey))) {
                return customKey;
            }
        }
        return null;
    }
}

