/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.convert;

import java.io.Serializable;
import java.util.Map;
import me.venise.core.convert.Converter;
import me.venise.core.util.ArrayUtil;
import me.venise.core.util.CharUtil;
import me.venise.core.util.ClassUtil;
import me.venise.core.util.StringUtil;

public abstract class AbstractConverter<T>
implements Converter,
Serializable {
    private static final long serialVersionUID = -8048083343320499068L;

    public T convertQuietly(Object value, T defaultValue) {
        try {
            return this.convert(value, (Object)defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public T convert(Object value, Object defaultValue) {
        Class<Object> targetType = this.getTargetType();
        if (null == targetType && null == defaultValue) {
            throw new NullPointerException(StringUtil.format("[type] and [defaultValue] are both null for Converter [{}], we can not know what type to convert !", this.getClass().getName()));
        }
        if (null == targetType) {
            targetType = defaultValue.getClass();
        }
        if (null == value) {
            return (T)defaultValue;
        }
        if (null == defaultValue || targetType.isInstance(defaultValue)) {
            if (targetType.isInstance(value) && !Map.class.isAssignableFrom(targetType)) {
                return (T)targetType.cast(value);
            }
            T result = this.convertInternal(value);
            return (T)(null == result ? defaultValue : result);
        }
        throw new IllegalArgumentException(StringUtil.format("Default value [{}]({}) is not the instance of [{}]", defaultValue, defaultValue.getClass(), targetType));
    }

    protected abstract T convertInternal(Object var1);

    protected String convertToStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayUtil.isArray(value)) {
            return ArrayUtil.toString(value);
        }
        if (CharUtil.isChar(value)) {
            return CharUtil.toString(((Character)value).charValue());
        }
        return value.toString();
    }

    public Class<T> getTargetType() {
        return ClassUtil.getTypeArgument(this.getClass());
    }
}

