/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.convert;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import me.venise.core.bean.BeanUtil;
import me.venise.core.convert.Converter;
import me.venise.core.convert.impl.ArrayConverter;
import me.venise.core.convert.impl.AtomicBooleanConverter;
import me.venise.core.convert.impl.AtomicIntegerArrayConverter;
import me.venise.core.convert.impl.AtomicLongArrayConverter;
import me.venise.core.convert.impl.AtomicReferenceConverter;
import me.venise.core.convert.impl.BeanConverter;
import me.venise.core.convert.impl.BooleanConverter;
import me.venise.core.convert.impl.CalendarConverter;
import me.venise.core.convert.impl.CharacterConverter;
import me.venise.core.convert.impl.CharsetConverter;
import me.venise.core.convert.impl.ClassConverter;
import me.venise.core.convert.impl.CollectionConverter;
import me.venise.core.convert.impl.ConvertException;
import me.venise.core.convert.impl.CurrencyConverter;
import me.venise.core.convert.impl.DateConverter;
import me.venise.core.convert.impl.DurationConverter;
import me.venise.core.convert.impl.EnumConverter;
import me.venise.core.convert.impl.LocaleConverter;
import me.venise.core.convert.impl.MapConverter;
import me.venise.core.convert.impl.NumberConverter;
import me.venise.core.convert.impl.OptionalConverter;
import me.venise.core.convert.impl.PathConverter;
import me.venise.core.convert.impl.PeriodConverter;
import me.venise.core.convert.impl.PrimitiveConverter;
import me.venise.core.convert.impl.ReferenceConverter;
import me.venise.core.convert.impl.StackTraceElementConverter;
import me.venise.core.convert.impl.StringConverter;
import me.venise.core.convert.impl.TemporalAccessorConverter;
import me.venise.core.convert.impl.TimeZoneConverter;
import me.venise.core.convert.impl.URIConverter;
import me.venise.core.convert.impl.URLConverter;
import me.venise.core.convert.impl.UUIDConverter;
import me.venise.core.date.DateTime;
import me.venise.core.lang.TypeReference;
import me.venise.core.util.ClassUtil;
import me.venise.core.util.ObjectUtil;
import me.venise.core.util.ReflectUtil;
import me.venise.core.util.ServiceLoaderUtil;
import me.venise.core.util.TypeUtil;

public class ConverterRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Type, Converter<?>> defaultConverterMap;
    private volatile Map<Type, Converter<?>> customConverterMap;

    public static ConverterRegistry getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public ConverterRegistry() {
        this.defaultConverter();
        this.putCustomBySpi();
    }

    private void putCustomBySpi() {
        ServiceLoaderUtil.load(Converter.class).forEach(converter -> {
            try {
                Type type = TypeUtil.getTypeArgument(ClassUtil.getClass(converter));
                if (null != type) {
                    this.putCustom(type, (Converter<?>)converter);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public ConverterRegistry putCustom(Type type, Class<? extends Converter<?>> converterClass) {
        return this.putCustom(type, ReflectUtil.newInstance(converterClass, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterRegistry putCustom(Type type, Converter<?> converter) {
        if (null == this.customConverterMap) {
            ConverterRegistry converterRegistry = this;
            synchronized (converterRegistry) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new ConcurrentHashMap();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    public <T> Converter<T> getConverter(Type type, boolean isCustomFirst) {
        Converter<T> converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public <T> Converter<T> getDefaultConverter(Type type) {
        return null == this.defaultConverterMap ? null : this.defaultConverterMap.get(type);
    }

    public <T> Converter<T> getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Object result;
        Converter<T> converter;
        if (TypeUtil.isUnknown(type) && null == defaultValue) {
            return (T)value;
        }
        if (ObjectUtil.isNull(value)) {
            return defaultValue;
        }
        if (TypeUtil.isUnknown(type)) {
            type = defaultValue.getClass();
        }
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(value, defaultValue);
        }
        Class<?> rowType = TypeUtil.getClass(type);
        if (null == rowType) {
            if (null != defaultValue) {
                rowType = defaultValue.getClass();
            } else {
                return (T)value;
            }
        }
        if (null != (result = this.convertSpecial(type, rowType, value, defaultValue))) {
            return (T)result;
        }
        if (BeanUtil.isBean(rowType)) {
            return new BeanConverter(type).convert(value, (Object)defaultValue);
        }
        throw new ConvertException("Can not Converter from [{}] to [{}]", value.getClass().getName(), type.getTypeName());
    }

    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    private <T> T convertSpecial(Type type, Class<T> rowType, Object value, T defaultValue) {
        if (null == rowType) {
            return null;
        }
        if (Collection.class.isAssignableFrom(rowType)) {
            CollectionConverter collectionConverter = new CollectionConverter(type);
            return (T)collectionConverter.convert(value, (Collection)defaultValue);
        }
        if (Map.class.isAssignableFrom(rowType)) {
            MapConverter mapConverter = new MapConverter(type);
            return mapConverter.convert(value, (Map)defaultValue);
        }
        if (rowType.isInstance(value)) {
            return (T)value;
        }
        if (rowType.isEnum()) {
            return new EnumConverter(rowType).convert(value, (Object)defaultValue);
        }
        if (rowType.isArray()) {
            ArrayConverter arrayConverter = new ArrayConverter(rowType);
            return arrayConverter.convert(value, (Object)defaultValue);
        }
        return null;
    }

    private ConverterRegistry defaultConverter() {
        this.defaultConverterMap = new ConcurrentHashMap();
        this.defaultConverterMap.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        this.defaultConverterMap.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        this.defaultConverterMap.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        this.defaultConverterMap.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        this.defaultConverterMap.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        this.defaultConverterMap.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        this.defaultConverterMap.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        this.defaultConverterMap.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        this.defaultConverterMap.put((Type)((Object)Number.class), new NumberConverter());
        this.defaultConverterMap.put((Type)((Object)Integer.class), new NumberConverter(Integer.class));
        this.defaultConverterMap.put((Type)((Object)AtomicInteger.class), new NumberConverter(AtomicInteger.class));
        this.defaultConverterMap.put((Type)((Object)Long.class), new NumberConverter(Long.class));
        this.defaultConverterMap.put((Type)((Object)AtomicLong.class), new NumberConverter(AtomicLong.class));
        this.defaultConverterMap.put((Type)((Object)Byte.class), new NumberConverter(Byte.class));
        this.defaultConverterMap.put((Type)((Object)Short.class), new NumberConverter(Short.class));
        this.defaultConverterMap.put((Type)((Object)Float.class), new NumberConverter(Float.class));
        this.defaultConverterMap.put((Type)((Object)Double.class), new NumberConverter(Double.class));
        this.defaultConverterMap.put((Type)((Object)Character.class), new CharacterConverter());
        this.defaultConverterMap.put((Type)((Object)Boolean.class), new BooleanConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicBoolean.class), new AtomicBooleanConverter());
        this.defaultConverterMap.put((Type)((Object)BigDecimal.class), new NumberConverter(BigDecimal.class));
        this.defaultConverterMap.put((Type)((Object)BigInteger.class), new NumberConverter(BigInteger.class));
        this.defaultConverterMap.put((Type)((Object)CharSequence.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)String.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)URI.class), new URIConverter());
        this.defaultConverterMap.put((Type)((Object)URL.class), new URLConverter());
        this.defaultConverterMap.put((Type)((Object)Calendar.class), new CalendarConverter());
        this.defaultConverterMap.put((Type)((Object)Date.class), new DateConverter(Date.class));
        this.defaultConverterMap.put((Type)((Object)DateTime.class), new DateConverter(DateTime.class));
        this.defaultConverterMap.put((Type)((Object)java.sql.Date.class), new DateConverter(java.sql.Date.class));
        this.defaultConverterMap.put((Type)((Object)Time.class), new DateConverter(Time.class));
        this.defaultConverterMap.put((Type)((Object)Timestamp.class), new DateConverter(Timestamp.class));
        this.defaultConverterMap.put((Type)((Object)TemporalAccessor.class), new TemporalAccessorConverter(Instant.class));
        this.defaultConverterMap.put((Type)((Object)Instant.class), new TemporalAccessorConverter(Instant.class));
        this.defaultConverterMap.put((Type)((Object)LocalDateTime.class), new TemporalAccessorConverter(LocalDateTime.class));
        this.defaultConverterMap.put((Type)((Object)LocalDate.class), new TemporalAccessorConverter(LocalDate.class));
        this.defaultConverterMap.put((Type)((Object)LocalTime.class), new TemporalAccessorConverter(LocalTime.class));
        this.defaultConverterMap.put((Type)((Object)ZonedDateTime.class), new TemporalAccessorConverter(ZonedDateTime.class));
        this.defaultConverterMap.put((Type)((Object)OffsetDateTime.class), new TemporalAccessorConverter(OffsetDateTime.class));
        this.defaultConverterMap.put((Type)((Object)OffsetTime.class), new TemporalAccessorConverter(OffsetTime.class));
        this.defaultConverterMap.put((Type)((Object)Period.class), new PeriodConverter());
        this.defaultConverterMap.put((Type)((Object)Duration.class), new DurationConverter());
        this.defaultConverterMap.put((Type)((Object)WeakReference.class), new ReferenceConverter(WeakReference.class));
        this.defaultConverterMap.put((Type)((Object)SoftReference.class), new ReferenceConverter(SoftReference.class));
        this.defaultConverterMap.put((Type)((Object)AtomicReference.class), new AtomicReferenceConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicIntegerArray.class), new AtomicIntegerArrayConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicLongArray.class), new AtomicLongArrayConverter());
        this.defaultConverterMap.put((Type)((Object)Class.class), new ClassConverter());
        this.defaultConverterMap.put((Type)((Object)TimeZone.class), new TimeZoneConverter());
        this.defaultConverterMap.put((Type)((Object)Locale.class), new LocaleConverter());
        this.defaultConverterMap.put((Type)((Object)Charset.class), new CharsetConverter());
        this.defaultConverterMap.put((Type)((Object)Path.class), new PathConverter());
        this.defaultConverterMap.put((Type)((Object)Currency.class), new CurrencyConverter());
        this.defaultConverterMap.put((Type)((Object)UUID.class), new UUIDConverter());
        this.defaultConverterMap.put((Type)((Object)StackTraceElement.class), new StackTraceElementConverter());
        this.defaultConverterMap.put((Type)((Object)Optional.class), new OptionalConverter());
        return this;
    }

    private static class SingletonHolder {
        private static final ConverterRegistry INSTANCE = new ConverterRegistry();

        private SingletonHolder() {
        }
    }
}

