/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.convert.impl;

import java.lang.reflect.Type;
import java.util.Map;
import me.venise.core.bean.BeanUtil;
import me.venise.core.bean.copier.BeanCopier;
import me.venise.core.bean.copier.CopyOptions;
import me.venise.core.bean.copier.ValueProvider;
import me.venise.core.convert.AbstractConverter;
import me.venise.core.convert.impl.ConvertException;
import me.venise.core.map.MapProxy;
import me.venise.core.util.ObjectUtil;
import me.venise.core.util.ReflectUtil;
import me.venise.core.util.TypeUtil;

public class BeanConverter<T>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 1L;
    private final Type beanType;
    private final Class<T> beanClass;
    private final CopyOptions copyOptions;

    public BeanConverter(Type beanType) {
        this(beanType, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Class<T> beanClass) {
        this(beanClass, CopyOptions.create().setIgnoreError(true));
    }

    public BeanConverter(Type beanType, CopyOptions copyOptions) {
        this.beanType = beanType;
        this.beanClass = TypeUtil.getClass(beanType);
        this.copyOptions = copyOptions;
    }

    @Override
    protected T convertInternal(Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanUtil.isBean(value.getClass())) {
            if (value instanceof Map && this.beanClass.isInterface()) {
                return MapProxy.create((Map)value).toProxyBean(this.beanClass);
            }
            return BeanCopier.create(value, ReflectUtil.newInstanceIfPossible(this.beanClass), this.beanType, this.copyOptions).copy();
        }
        if (value instanceof byte[]) {
            return ObjectUtil.deserialize((byte[])value);
        }
        throw new ConvertException("Unsupported source type: {}", value.getClass());
    }

    @Override
    public Class<T> getTargetType() {
        return this.beanClass;
    }
}

