/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.convert.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import me.venise.core.convert.AbstractConverter;
import me.venise.core.convert.ConverterRegistry;
import me.venise.core.util.StringUtil;
import me.venise.core.util.TypeUtil;

public class ReferenceConverter
extends AbstractConverter<Reference> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Reference> targetType;

    public ReferenceConverter(Class<? extends Reference> targetType) {
        this.targetType = targetType;
    }

    @Override
    protected Reference<?> convertInternal(Object value) {
        Object targetValue = null;
        Type paramType = TypeUtil.getTypeArgument(this.targetType);
        if (!TypeUtil.isUnknown(paramType)) {
            targetValue = ConverterRegistry.getInstance().convert(paramType, value);
        }
        if (null == targetValue) {
            targetValue = value;
        }
        if (this.targetType == WeakReference.class) {
            return new WeakReference<Object>(targetValue);
        }
        if (this.targetType == SoftReference.class) {
            return new SoftReference<Object>(targetValue);
        }
        throw new UnsupportedOperationException(StringUtil.format("Unsupport Reference type: {}", this.targetType.getName()));
    }
}

