/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.convert.impl;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.TimeZone;
import me.venise.core.convert.AbstractConverter;
import me.venise.core.convert.impl.ConvertException;
import me.venise.core.io.IoUtil;
import me.venise.core.util.CharsetUtil;
import me.venise.core.util.XmlUtil;
import org.w3c.dom.Node;

public class StringConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 1L;

    @Override
    protected String convertInternal(Object value) {
        if (value instanceof TimeZone) {
            return ((TimeZone)value).getID();
        }
        if (value instanceof Node) {
            return XmlUtil.toStr((Node)value);
        }
        if (value instanceof Clob) {
            return StringConverter.clobToStr((Clob)value);
        }
        if (value instanceof Blob) {
            return StringConverter.blobToStr((Blob)value);
        }
        return this.convertToStr(value);
    }

    private static String clobToStr(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            String string = IoUtil.read(reader);
            return string;
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
        finally {
            IoUtil.close(reader);
        }
    }

    private static String blobToStr(Blob blob) {
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            String string = IoUtil.read(in, CharsetUtil.CHARSET_UTF_8);
            return string;
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }
}

