/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import me.venise.core.io.FastByteArrayOutputStream;
import me.venise.core.io.IORuntimeException;
import me.venise.core.io.StreamProgress;
import me.venise.core.lang.Assert;
import me.venise.core.util.CharsetUtil;
import me.venise.core.util.StringUtil;

public class NioUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        return NioUtil.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, streamProgress);
    }

    public static long copy(FileChannel inChannel, FileChannel outChannel) throws IORuntimeException {
        Assert.notNull(inChannel, "In channel is null!", new Object[0]);
        Assert.notNull(outChannel, "Out channel is null!", new Object[0]);
        try {
            return inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out) throws IORuntimeException {
        return NioUtil.copy(in, out, 8192);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize) throws IORuntimeException {
        return NioUtil.copy(in, out, bufferSize, null);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws IORuntimeException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        Assert.notNull(out, "OutputStream is null !", new Object[0]);
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize <= 0 ? 8192 : bufferSize);
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            while (in.read(byteBuffer) != -1) {
                byteBuffer.flip();
                size += (long)out.write(byteBuffer);
                byteBuffer.clear();
                if (null == streamProgress) continue;
                streamProgress.progress(size);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static String read(ReadableByteChannel channel, Charset charset) throws IORuntimeException {
        FastByteArrayOutputStream out = NioUtil.read(channel);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static FastByteArrayOutputStream read(ReadableByteChannel channel) throws IORuntimeException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        NioUtil.copy(channel, Channels.newChannel(out));
        return out;
    }

    public static String readUtf8(FileChannel fileChannel) throws IORuntimeException {
        return NioUtil.read(fileChannel, CharsetUtil.CHARSET_UTF_8);
    }

    public static String read(FileChannel fileChannel, String charsetName) throws IORuntimeException {
        return NioUtil.read(fileChannel, CharsetUtil.charset(charsetName));
    }

    public static String read(FileChannel fileChannel, Charset charset) throws IORuntimeException {
        MappedByteBuffer buffer;
        try {
            buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return StringUtil.str((ByteBuffer)buffer, charset);
    }

    public static void close(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

