/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.io.resource;

import java.net.URL;
import me.venise.core.io.FileUtil;
import me.venise.core.io.resource.NoResourceException;
import me.venise.core.io.resource.UrlResource;
import me.venise.core.lang.Assert;
import me.venise.core.util.ClassUtil;
import me.venise.core.util.ObjectUtil;
import me.venise.core.util.StringUtil;
import me.venise.core.util.URLUtil;

public class ClassPathResource
extends UrlResource {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final ClassLoader classLoader;
    private final Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, null, null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        this(path, classLoader, null);
    }

    public ClassPathResource(String path, Class<?> clazz) {
        this(path, null, clazz);
    }

    public ClassPathResource(String pathBaseClassLoader, ClassLoader classLoader, Class<?> clazz) {
        super((URL)null);
        String path;
        Assert.notNull(pathBaseClassLoader, "Path must not be null", new Object[0]);
        this.path = path = this.normalizePath(pathBaseClassLoader);
        this.name = StringUtil.isBlank(path) ? null : FileUtil.getName(path);
        this.classLoader = ObjectUtil.defaultIfNull(classLoader, ClassUtil.getClassLoader());
        this.clazz = clazz;
        this.initUrl();
    }

    public final String getPath() {
        return this.path;
    }

    public final String getAbsolutePath() {
        if (FileUtil.isAbsolutePath(this.path)) {
            return this.path;
        }
        return FileUtil.normalize(URLUtil.getDecodedPath(this.url));
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void initUrl() {
        this.url = null != this.clazz ? this.clazz.getResource(this.path) : (null != this.classLoader ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
        if (null == this.url) {
            throw new NoResourceException("Resource of path [{}] not exist!", this.path);
        }
    }

    @Override
    public String toString() {
        return null == this.path ? super.toString() : "classpath:" + this.path;
    }

    private String normalizePath(String path) {
        path = FileUtil.normalize(path);
        path = StringUtil.removePrefix(path, "/");
        Assert.isFalse(FileUtil.isAbsolutePath(path), "Path [{}] must be a relative path !", path);
        return path;
    }
}

