/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import me.venise.core.io.FileUtil;
import me.venise.core.io.resource.NoResourceException;
import me.venise.core.io.resource.Resource;
import me.venise.core.util.URLUtil;

public class FileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;

    public FileResource(Path path) {
        this(path.toFile());
    }

    public FileResource(File file) {
        this(file, file.getName());
    }

    public FileResource(File file, String fileName) {
        this.file = file;
    }

    public FileResource(String path) {
        this(FileUtil.file(path));
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public URL getUrl() {
        return URLUtil.getURL(this.file);
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        return FileUtil.getInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return null == this.file ? "null" : this.file.toString();
    }
}

