/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import me.venise.core.io.FileUtil;
import me.venise.core.io.resource.NoResourceException;
import me.venise.core.io.resource.Resource;
import me.venise.core.util.ObjectUtil;
import me.venise.core.util.URLUtil;

public class UrlResource
implements Resource,
Serializable {
    private static final long serialVersionUID = -3499280407178572407L;
    protected URL url;
    protected String name;

    public UrlResource(URL url) {
        this(url, null);
    }

    public UrlResource(URL url, String name) {
        this.url = url;
        this.name = ObjectUtil.defaultIfNull(name, null != url ? FileUtil.getName(url.getPath()) : null);
    }

    @Deprecated
    public UrlResource(File file) {
        this.url = URLUtil.getURL(file);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        if (null == this.url) {
            throw new NoResourceException("Resource URL is null!");
        }
        return URLUtil.getStream(this.url);
    }

    public File getFile() {
        return FileUtil.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

