/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.lang;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.venise.core.collection.CollUtil;
import me.venise.core.collection.EnumerationIter;
import me.venise.core.io.IORuntimeException;
import me.venise.core.io.resource.ResourceUtil;
import me.venise.core.lang.Filter;
import me.venise.core.util.CharsetUtil;
import me.venise.core.util.ClassLoaderUtil;
import me.venise.core.util.ClassUtil;
import me.venise.core.util.StringUtil;
import me.venise.core.util.URLUtil;

public class ClassScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String packageNameWithDot;
    private final String packageDirName;
    private final String packagePath;
    private final Filter<Class<?>> classFilter;
    private final Charset charset;
    private ClassLoader classLoader;
    private boolean initialize;
    private final Set<Class<?>> classes = new HashSet();

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanPackage(packageName, clazz -> superClass.isAssignableFrom((Class<?>)clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        return new ClassScanner(packageName, classFilter).scan();
    }

    public ClassScanner() {
        this(null);
    }

    public ClassScanner(String packageName) {
        this(packageName, null);
    }

    public ClassScanner(String packageName, Filter<Class<?>> classFilter) {
        this(packageName, classFilter, CharsetUtil.CHARSET_UTF_8);
    }

    public ClassScanner(String packageName, Filter<Class<?>> classFilter, Charset charset) {
        this.packageName = packageName = StringUtil.nullToEmpty(packageName);
        this.packageNameWithDot = StringUtil.addSuffixIfNot(packageName, ".");
        this.packageDirName = packageName.replace('.', File.separatorChar);
        this.packagePath = packageName.replace('.', '/');
        this.classFilter = classFilter;
        this.charset = charset;
    }

    public Set<Class<?>> scan() {
        for (URL url : ResourceUtil.getResourceIter(this.packagePath)) {
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(URLUtil.decode(url.getFile(), this.charset.name())), null);
                    break;
                }
                case "jar": {
                    this.scanJar(URLUtil.getJarFile(url));
                }
            }
        }
        if (CollUtil.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void scanJavaClassPaths() {
        String[] javaClassPaths;
        for (String classPath : javaClassPaths = ClassUtil.getJavaClassPaths()) {
            classPath = URLUtil.decode(classPath, CharsetUtil.systemCharsetName());
            this.scanFile(new File(classPath), null);
        }
    }

    private void scanFile(File file, String rootDir) {
        File[] files;
        if (file.isFile()) {
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(".class")) {
                String className = fileName.substring(rootDir.length(), fileName.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(className);
            } else if (fileName.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
        } else if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File subFile : files) {
                this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    private void scanJar(JarFile jar) {
        for (JarEntry entry : new EnumerationIter<JarEntry>(jar.entries())) {
            String name = StringUtil.removePrefix(entry.getName(), "/");
            if (!name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            this.addIfAccept(this.loadClass(className));
        }
    }

    private Class<?> loadClass(String className) {
        ClassLoader loader = this.classLoader;
        if (null == loader) {
            this.classLoader = loader = ClassLoaderUtil.getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, this.initialize, loader);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clazz;
    }

    private void addIfAccept(String className) {
        int packageLen;
        if (StringUtil.isBlank(className)) {
            return;
        }
        int classLen = className.length();
        if (classLen == (packageLen = this.packageName.length())) {
            if (className.equals(this.packageName)) {
                this.addIfAccept(this.loadClass(className));
            }
        } else if (classLen > packageLen && className.startsWith(this.packageNameWithDot)) {
            this.addIfAccept(this.loadClass(className));
        }
    }

    private void addIfAccept(Class<?> clazz) {
        Filter<Class<?>> classFilter;
        if (null != clazz && ((classFilter = this.classFilter) == null || classFilter.accept(clazz))) {
            this.classes.add(clazz);
        }
    }

    private String subPathBeforePackage(File file) {
        String filePath = file.getAbsolutePath();
        if (StringUtil.isNotEmpty(this.packageDirName)) {
            filePath = StringUtil.subBefore((CharSequence)filePath, this.packageDirName, true);
        }
        return StringUtil.addSuffixIfNot(filePath, File.separator);
    }
}

