/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.lang;

import java.io.Serializable;
import java.util.Objects;
import me.venise.core.clone.CloneSupport;

public class Pair<K, V>
extends CloneSupport<Pair<K, V>>
implements Serializable {
    private static final long serialVersionUID = 5766865261735740229L;
    private final K key;
    private final V value;

    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    public V getValue() {
        return this.value;
    }

    public K getKey() {
        return this.key;
    }

    public String toString() {
        return "Pair [key=" + this.key + ", value=" + this.value + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Pair) {
            Pair pair = (Pair)o;
            return Objects.equals(this.getKey(), pair.getKey()) && Objects.equals(this.getValue(), pair.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
    }
}

