/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.lang;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import me.venise.core.lang.func.Functions;

public class SimpleCache<K, V>
implements Iterable<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = -7320020986472578978L;
    private final Map<K, V> cache;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Map<K, Lock> keyLockMap = new ConcurrentHashMap<K, Lock>();

    public SimpleCache() {
        this(new WeakHashMap());
    }

    public SimpleCache(Map<K, V> initMap) {
        this.cache = initMap;
    }

    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v = this.cache.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Functions<V> supplier) {
        V v;
        block6: {
            v = this.get(key);
            if (null == v && null != supplier) {
                Lock keyLock = this.keyLockMap.computeIfAbsent(key, k -> new ReentrantLock());
                keyLock.lock();
                try {
                    v = this.cache.get(key);
                    if (null != v) break block6;
                    try {
                        v = supplier.call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.put(key, v);
                }
                finally {
                    keyLock.unlock();
                    this.keyLockMap.remove(key);
                }
            }
        }
        return v;
    }

    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.cache.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return value;
    }

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v = this.cache.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.cache.entrySet().iterator();
    }
}

