/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.lang;

import java.util.HashMap;
import me.venise.core.lang.Assert;
import me.venise.core.lang.SimpleCache;
import me.venise.core.lang.func.Functions;
import me.venise.core.util.ArrayUtil;
import me.venise.core.util.ClassUtil;
import me.venise.core.util.ReflectUtil;
import me.venise.core.util.StringUtil;

public class Singleton {
    private static final SimpleCache<String, Object> POOL = new SimpleCache(new HashMap());

    private Singleton() {
    }

    public static <T> T get(Class<T> clazz, Object ... params) {
        Assert.notNull(clazz, "Class must be not null !", new Object[0]);
        String key = Singleton.buildKey(clazz.getName(), params);
        return (T)Singleton.get(key, () -> ReflectUtil.newInstance(clazz, params));
    }

    public static <T> T get(String key, Functions<T> supplier) {
        return (T)POOL.get(key, supplier::call);
    }

    public static <T> T get(String className, Object ... params) {
        Assert.notBlank(className, "Class name must be not blank !", new Object[0]);
        Class clazz = ClassUtil.loadClass(className);
        return Singleton.get(clazz, params);
    }

    public static void put(Object obj) {
        Assert.notNull(obj, "Bean object must be not null !", new Object[0]);
        Singleton.put(obj.getClass().getName(), obj);
    }

    public static void put(String key, Object obj) {
        POOL.put(key, obj);
    }

    public static void remove(Class<?> clazz) {
        if (null != clazz) {
            Singleton.remove(clazz.getName());
        }
    }

    public static void remove(String key) {
        POOL.remove(key);
    }

    public static void destroy() {
        POOL.clear();
    }

    private static String buildKey(String className, Object ... params) {
        if (ArrayUtil.isEmpty(params)) {
            return className;
        }
        return StringUtil.format("{}#{}", className, ArrayUtil.join(params, (CharSequence)"_"));
    }
}

