/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.map;

import java.util.LinkedHashMap;
import java.util.Map;
import me.venise.core.map.CustomKeyMap;
import me.venise.core.util.StringUtil;

public class CamelCaseLinkedMap<K, V>
extends CustomKeyMap<K, V> {
    private static final long serialVersionUID = 4043263744224569870L;

    public CamelCaseLinkedMap() {
        this(16);
    }

    public CamelCaseLinkedMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CamelCaseLinkedMap(Map<? extends K, ? extends V> m) {
        this(0.75f, m);
    }

    public CamelCaseLinkedMap(float loadFactor, Map<? extends K, ? extends V> m) {
        this(m.size(), loadFactor);
        this.putAll(m);
    }

    public CamelCaseLinkedMap(int initialCapacity, float loadFactor) {
        super(new LinkedHashMap(initialCapacity, loadFactor));
    }

    @Override
    protected Object customKey(Object key) {
        if (key instanceof CharSequence) {
            key = StringUtil.toCamelCase(key.toString());
        }
        return key;
    }
}

