/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.map;

import java.util.HashMap;
import java.util.Map;
import me.venise.core.map.CustomKeyMap;
import me.venise.core.util.StringUtil;

public class CamelCaseMap<K, V>
extends CustomKeyMap<K, V> {
    private static final long serialVersionUID = 4043263744224569870L;

    public CamelCaseMap() {
        this(16);
    }

    public CamelCaseMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CamelCaseMap(Map<? extends K, ? extends V> m) {
        this(0.75f, m);
    }

    public CamelCaseMap(float loadFactor, Map<? extends K, ? extends V> m) {
        this(m.size(), loadFactor);
        this.putAll(m);
    }

    public CamelCaseMap(int initialCapacity, float loadFactor) {
        super(new HashMap(initialCapacity, loadFactor));
    }

    @Override
    protected Object customKey(Object key) {
        if (key instanceof CharSequence) {
            key = StringUtil.toCamelCase(key.toString());
        }
        return key;
    }
}

