/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.map;

import java.io.Serializable;
import java.util.Map;
import me.venise.core.map.MapUtil;

public class MapBuilder<K, V>
implements Serializable {
    private static final long serialVersionUID = 8877225868415371454L;
    private final Map<K, V> map;

    public static <K, V> MapBuilder<K, V> create() {
        return MapBuilder.create(false);
    }

    public static <K, V> MapBuilder<K, V> create(boolean isLinked) {
        return MapBuilder.create(MapUtil.newHashMap(isLinked));
    }

    public static <K, V> MapBuilder<K, V> create(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public MapBuilder(Map<K, V> map) {
        this.map = map;
    }

    public MapBuilder<K, V> put(K k, V v) {
        this.map.put(k, v);
        return this;
    }

    public MapBuilder<K, V> putAll(Map<K, V> map) {
        this.map.putAll(map);
        return this;
    }

    public Map<K, V> map() {
        return this.map;
    }

    public Map<K, V> build() {
        return this.map();
    }

    public String join(String separator, String keyValueSeparator) {
        return MapUtil.join(this.map, separator, keyValueSeparator, new String[0]);
    }

    public String joinIgnoreNull(String separator, String keyValueSeparator) {
        return MapUtil.joinIgnoreNull(this.map, separator, keyValueSeparator, new String[0]);
    }

    public String join(String separator, String keyValueSeparator, boolean isIgnoreNull) {
        return MapUtil.join(this.map, separator, keyValueSeparator, isIgnoreNull, new String[0]);
    }
}

