/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.net.url;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import me.venise.core.collection.CollUtil;
import me.venise.core.lang.Assert;
import me.venise.core.net.URLDecoder;
import me.venise.core.util.StringUtil;
import me.venise.core.util.URLUtil;

public class UrlPath {
    private List<String> segments;
    private boolean withEngTag;

    public static UrlPath of(String pathStr, Charset charset) {
        UrlPath urlPath = new UrlPath();
        urlPath.parse(pathStr, charset);
        return urlPath;
    }

    public UrlPath setWithEndTag(boolean withEngTag) {
        this.withEngTag = withEngTag;
        return this;
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public String getSegment(int index) {
        if (null == this.segments || index >= this.segments.size()) {
            return null;
        }
        return this.segments.get(index);
    }

    public UrlPath add(CharSequence segment) {
        this.addInternal(UrlPath.fixPath(segment), false);
        return this;
    }

    public UrlPath addBefore(CharSequence segment) {
        this.addInternal(UrlPath.fixPath(segment), true);
        return this;
    }

    public UrlPath parse(String path, Charset charset) {
        if (StringUtil.isNotEmpty(path)) {
            if (StringUtil.endWith((CharSequence)path, '/')) {
                this.withEngTag = true;
            }
            path = UrlPath.fixPath(path);
            List<String> split = StringUtil.split((CharSequence)path, '/');
            for (String seg : split) {
                this.addInternal(URLDecoder.decodeForPath(seg, charset), false);
            }
        }
        return this;
    }

    public String build(Charset charset) {
        if (CollUtil.isEmpty(this.segments)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String segment : this.segments) {
            builder.append('/').append(URLUtil.encode(segment, charset));
        }
        if (this.withEngTag || StringUtil.isEmpty(builder)) {
            builder.append('/');
        }
        return builder.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private void addInternal(CharSequence segment, boolean before) {
        if (this.segments == null) {
            this.segments = new LinkedList<String>();
        }
        String seg = StringUtil.str(segment);
        if (before) {
            this.segments.add(0, seg);
        } else {
            this.segments.add(seg);
        }
    }

    private static String fixPath(CharSequence path) {
        Assert.notNull(path, "Path segment must be not null!", new Object[0]);
        if ("/".contentEquals(path)) {
            return "";
        }
        String segmentStr = StringUtil.trim(path);
        segmentStr = StringUtil.removePrefix(segmentStr, "/");
        segmentStr = StringUtil.removeSuffix(segmentStr, "/");
        segmentStr = StringUtil.trim(segmentStr);
        return segmentStr;
    }
}

