/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.text.replacer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import me.venise.core.lang.Chain;
import me.venise.core.lang.StrBuilder;
import me.venise.core.text.replacer.StringReplacer;

public class ReplacerChain
extends StringReplacer
implements Chain<StringReplacer, ReplacerChain> {
    private static final long serialVersionUID = 1L;
    private final List<StringReplacer> replacers = new LinkedList<StringReplacer>();

    public ReplacerChain(StringReplacer ... strReplacers) {
        for (StringReplacer strReplacer : strReplacers) {
            this.addChain(strReplacer);
        }
    }

    @Override
    public Iterator<StringReplacer> iterator() {
        return this.replacers.iterator();
    }

    @Override
    public ReplacerChain addChain(StringReplacer element) {
        this.replacers.add(element);
        return this;
    }

    @Override
    protected int replace(CharSequence str, int pos, StrBuilder out) {
        int consumed = 0;
        for (StringReplacer strReplacer : this.replacers) {
            consumed = strReplacer.replace(str, pos, out);
            if (0 == consumed) continue;
            return consumed;
        }
        return consumed;
    }
}

