/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.thread;

import java.util.concurrent.Semaphore;

public class SemaphoreRunnable
implements Runnable {
    private final Runnable runnable;
    private final Semaphore semaphore;

    public SemaphoreRunnable(Runnable runnable, Semaphore semaphore) {
        this.runnable = runnable;
        this.semaphore = semaphore;
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    @Override
    public void run() {
        if (null != this.semaphore) {
            try {
                this.semaphore.acquire();
                try {
                    this.runnable.run();
                }
                finally {
                    this.semaphore.release();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

