/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.venise.core.exceptions.UtilException;

public class RandomUtil {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] sed) {
        return null == sed ? new SecureRandom() : new SecureRandom(sed);
    }

    public static SecureRandom getSecureRandom() {
        return RandomUtil.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] sed) {
        return RandomUtil.createSecureRandom(sed);
    }

    public static SecureRandom getSHA1PRNGRandom(byte[] seed) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilException(e);
        }
        if (null != seed) {
            random.setSeed(seed);
        }
        return random;
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomUtil.getSecureRandom() : RandomUtil.getRandom();
    }

    public static boolean randomBoolean() {
        return 0 == RandomUtil.randomInt(2);
    }

    public static int randomInt(int min, int max) {
        return RandomUtil.getRandom().nextInt(min, max);
    }

    public static int randomInt() {
        return RandomUtil.getRandom().nextInt();
    }

    public static int randomInt(int limit) {
        return RandomUtil.getRandom().nextInt(limit);
    }

    public static long randomLong(long min, long max) {
        return RandomUtil.getRandom().nextLong(min, max);
    }

    public static long randomLong() {
        return RandomUtil.getRandom().nextLong();
    }

    public static long randomLong(int limit) {
        return RandomUtil.getRandom().nextLong(limit);
    }
}

