/*
 * Decompiled with CFR 0.152.
 */
package me.venise.core.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import me.venise.core.lang.StrBuilder;
import me.venise.core.text.CharSequenceUtil;
import me.venise.core.text.StringPool;
import me.venise.core.text.TextSimilarity;
import me.venise.core.util.ArrayUtil;
import me.venise.core.util.CharsetUtil;
import me.venise.core.util.IdUtil;

public class StringUtil
extends CharSequenceUtil
implements StringPool {
    public static boolean isBlankIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StringUtil.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isEmptyIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = StringUtil.trim(str);
        }
    }

    public static String utf8Str(Object obj) {
        return StringUtil.str(obj, CharsetUtil.CHARSET_UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return StringUtil.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringUtil.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StringUtil.str(bytes, StringUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StringUtil.str(bytes, StringUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringUtil.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StringUtil.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String toString(Object obj) {
        return null == obj ? "null" : obj.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StrBuilder strBuilder() {
        return StrBuilder.create();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StrBuilder strBuilder(int capacity) {
        return StrBuilder.create(capacity);
    }

    public static StringReader getReader(CharSequence str) {
        if (null == str) {
            return null;
        }
        return new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static String reverse(String str) {
        return new String(ArrayUtil.reverse(str.toCharArray()));
    }

    public static String fillBefore(String str, char filledChar, int len) {
        return StringUtil.fill(str, filledChar, len, true);
    }

    public static String fillAfter(String str, char filledChar, int len) {
        return StringUtil.fill(str, filledChar, len, false);
    }

    public static String fill(String str, char filledChar, int len, boolean isPre) {
        int strLen = str.length();
        if (strLen > len) {
            return str;
        }
        String filledStr = StringUtil.repeat(filledChar, len - strLen);
        return isPre ? filledStr.concat(str) : str.concat(filledStr);
    }

    public static double similar(String str1, String str2) {
        return TextSimilarity.similar(str1, str2);
    }

    public static String similar(String str1, String str2, int scale) {
        return TextSimilarity.similar(str1, str2, scale);
    }

    public static String uuid() {
        return IdUtil.randomUUID();
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        return StringUtil.format(template, map, true);
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        if (null == template) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return template.toString();
        }
        String template2 = template.toString();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String value = StringUtil.utf8Str(entry.getValue());
            if (null == value && ignoreNull) continue;
            template2 = StringUtil.replace((CharSequence)template2, (CharSequence)("{" + entry.getKey() + "}"), value);
        }
        return template2;
    }
}

