/*
 * Decompiled with CFR 0.152.
 */
package jsonrpc4s;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import jsonrpc4s.CancelParams;
import jsonrpc4s.Message;
import jsonrpc4s.NamedJsonRpcService;
import jsonrpc4s.Notification;
import jsonrpc4s.Request;
import jsonrpc4s.RequestId;
import jsonrpc4s.Response;
import jsonrpc4s.Response$;
import jsonrpc4s.Response$None$;
import jsonrpc4s.RpcActions$cancelRequest$;
import jsonrpc4s.RpcClient;
import jsonrpc4s.RpcServer$;
import jsonrpc4s.Service;
import jsonrpc4s.Service$;
import jsonrpc4s.Services;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scribe.Loggable;
import scribe.LoggerSupport;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\r\u001a\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\"\u0002$\u0001\t#9\u0005b\u0002(\u0001\u0005\u0004%\tb\u0014\u0005\u0007C\u0002\u0001\u000b\u0011\u0002)\t\u000f\t\u0004!\u0019!C\tG\"1q\r\u0001Q\u0001\n\u0011Dq\u0001\u001b\u0001C\u0002\u0013E\u0011\u000e\u0003\u0004y\u0001\u0001\u0006IA\u001b\u0005\u0006s\u0002!\tA\u001f\u0005\u0006}\u0002!\ta \u0005\b\u0003\u001b\u0001A\u0011CA\b\u0011\u001d\t9\u0002\u0001C\t\u00033Aq!!\n\u0001\t#\t9\u0003C\u0004\u00024\u0001!\t\"!\u000e\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u001d9\u00111I\r\t\u0002\u0005\u0015cA\u0002\r\u001a\u0011\u0003\t9\u0005\u0003\u0004G+\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u0017*B\u0011AA'\u0005%\u0011\u0006oY*feZ,'OC\u0001\u001b\u0003%Q7o\u001c8sa\u000e$4o\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g-\u0001\u0002j]B\u0019QE\u000b\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0011I,\u0017m\u0019;jm\u0016T\u0011!K\u0001\u0006[>t\u0017\u000e_\u0005\u0003W\u0019\u0012!b\u00142tKJ4\u0018M\u00197f!\tic&D\u0001\u001a\u0013\ty\u0013DA\u0004NKN\u001c\u0018mZ3\u0002\r\rd\u0017.\u001a8u!\ti#'\u0003\u000243\tI!\u000b]2DY&,g\u000e^\u0001\tg\u0016\u0014h/[2fgB\u0011QFN\u0005\u0003oe\u0011\u0001bU3sm&\u001cWm]\u0001\u0011e\u0016\fX/Z:u'\u000eDW\rZ;mKJ\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0015\u0002\u0013\u0015DXmY;uS>t\u0017B\u0001 <\u0005%\u00196\r[3ek2,'/\u0001\u0004m_\u001e<WM\u001d\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u000611o\u0019:jE\u0016L!!\u0012\"\u0003\u001b1{wmZ3s'V\u0004\bo\u001c:u\u0003\u0019a\u0014N\\5u}Q1\u0001*\u0013&L\u00196\u0003\"!\f\u0001\t\u000b\r2\u0001\u0019\u0001\u0013\t\u000bA2\u0001\u0019A\u0019\t\u000bQ2\u0001\u0019A\u001b\t\u000ba2\u0001\u0019A\u001d\t\u000b}2\u0001\u0019\u0001!\u0002)\u0005\u001cG/\u001b<f\u00072LWM\u001c;SKF,Xm\u001d;t+\u0005\u0001\u0006\u0003B)W1nk\u0011A\u0015\u0006\u0003'R\u000b!bY8oGV\u0014(/\u001a8u\u0015\t)v$\u0001\u0006d_2dWm\u0019;j_:L!a\u0016*\u0003\u000fQ\u0013\u0018.Z'baB\u0011Q&W\u0005\u00035f\u0011\u0011BU3rk\u0016\u001cH/\u00133\u0011\u0007ibf,\u0003\u0002^w\t\u00012)\u00198dK2\f'\r\\3GkR,(/\u001a\t\u0003[}K!\u0001Y\r\u0003\u0011I+7\u000f]8og\u0016\fQ#Y2uSZ,7\t\\5f]R\u0014V-];fgR\u001c\b%\u0001\ndC:\u001cW\r\u001c(pi&4\u0017nY1uS>tW#\u00013\u0011\u00055*\u0017B\u00014\u001a\u0005Mq\u0015-\\3e\u0015N|gN\u00159d'\u0016\u0014h/[2f\u0003M\u0019\u0017M\\2fY:{G/\u001b4jG\u0006$\u0018n\u001c8!\u0003QA\u0017M\u001c3mKJ\u001c()_'fi\"|GMT1nKV\t!\u000e\u0005\u0003leV$gB\u00017q!\tiw$D\u0001o\u0015\ty7$\u0001\u0004=e>|GOP\u0005\u0003c~\ta\u0001\u0015:fI\u00164\u0017BA:u\u0005\ri\u0015\r\u001d\u0006\u0003c~\u0001\"a\u001b<\n\u0005]$(AB*ue&tw-A\u000biC:$G.\u001a:t\u0005flU\r\u001e5pI:\u000bW.\u001a\u0011\u00025\r\fgnY3m\u0003\u000e$\u0018N^3DY&,g\u000e\u001e*fcV,7\u000f^:\u0015\u0003m\u0004\"A\b?\n\u0005u|\"\u0001B+oSR\f1d^1ji\u001a{'/Q2uSZ,7\t\\5f]R\u0014V-];fgR\u001cXCAA\u0001!\u0015\t\u0019!!\u0003|\u001b\t\t)AC\u0002\u0002\b!\nA!\u001a<bY&!\u00111BA\u0003\u0005\u0011!\u0016m]6\u0002\u001d!\fg\u000e\u001a7f%\u0016\u001c\bo\u001c8tKR!\u0011\u0011CA\n!\u0015\t\u0019!!\u0003_\u0011\u0019\t)b\u0004a\u0001=\u0006A!/Z:q_:\u001cX-A\u0007iC:$G.\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003#\tY\u0002C\u0004\u0002\u001eA\u0001\r!a\b\u0002\u000fI,\u0017/^3tiB\u0019Q&!\t\n\u0007\u0005\r\u0012DA\u0004SKF,Xm\u001d;\u0002%!\fg\u000e\u001a7f\u001d>$\u0018NZ5dCRLwN\u001c\u000b\u0005\u0003#\tI\u0003C\u0004\u0002,E\u0001\r!!\f\u0002\u00199|G/\u001b4jG\u0006$\u0018n\u001c8\u0011\u00075\ny#C\u0002\u00022e\u0011ABT8uS\u001aL7-\u0019;j_:\f!\u0003[1oI2,g+\u00197jI6+7o]1hKR!\u0011\u0011CA\u001c\u0011\u0019\tID\u0005a\u0001Y\u00059Q.Z:tC\u001e,\u0017!C:uCJ$H+Y:l)\u0011\t\t!a\u0010\t\u000f\u0005\u00053\u00031\u0001\u0002\u0002\u0005q\u0011M\u001a;feN+(m]2sS\n,\u0017!\u0003*qGN+'O^3s!\tiSc\u0005\u0002\u0016;Q\u0011\u0011QI\u0001\u0006CB\u0004H.\u001f\u000b\f\u0011\u0006=\u0013\u0011KA*\u0003+\n9\u0006C\u0003$/\u0001\u0007A\u0005C\u00031/\u0001\u0007\u0011\u0007C\u00035/\u0001\u0007Q\u0007C\u00039/\u0001\u0007\u0011\bC\u0003@/\u0001\u0007\u0001\t")
public class RpcServer {
    private final Observable<Message> in;
    private final RpcClient client;
    private final Scheduler requestScheduler;
    public final LoggerSupport jsonrpc4s$RpcServer$$logger;
    private final TrieMap<RequestId, CancelableFuture<Response>> activeClientRequests;
    private final NamedJsonRpcService cancelNotification;
    private final Map<String, NamedJsonRpcService> handlersByMethodName;

    public static RpcServer apply(Observable<Message> in, RpcClient client, Services services, Scheduler requestScheduler, LoggerSupport logger) {
        return RpcServer$.MODULE$.apply(in, client, services, requestScheduler, logger);
    }

    public TrieMap<RequestId, CancelableFuture<Response>> activeClientRequests() {
        return this.activeClientRequests;
    }

    public NamedJsonRpcService cancelNotification() {
        return this.cancelNotification;
    }

    public Map<String, NamedJsonRpcService> handlersByMethodName() {
        return this.handlersByMethodName;
    }

    public void cancelActiveClientRequests() {
        this.activeClientRequests().values().foreach((Function1 & Serializable)x$1 -> {
            x$1.cancel();
            return BoxedUnit.UNIT;
        });
    }

    public Task<BoxedUnit> waitForActiveClientRequests() {
        Iterable futures = (Iterable)this.activeClientRequests().values().map((Function1 & Serializable)fut -> Task$.MODULE$.fromFuture((Future)fut));
        return Task$.MODULE$.gatherUnordered(futures).materialize().map((Function1 & Serializable)x$2 -> {
            RpcServer.$anonfun$waitForActiveClientRequests$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    public Task<Response> handleResponse(Response response) {
        return Task$.MODULE$.evalAsync((Function0 & Serializable)() -> {
            $this.client.clientRespond(response);
            return Response$None$.MODULE$;
        });
    }

    public Task<Response> handleRequest(Request request) {
        Task task;
        Request request2 = request;
        if (request2 == null) {
            throw new MatchError((Object)request2);
        }
        String method = request2.method();
        RequestId id = request2.id();
        Tuple2 tuple2 = new Tuple2((Object)method, (Object)id);
        Tuple2 tuple22 = tuple2;
        String method2 = (String)tuple22._1();
        RequestId id2 = (RequestId)tuple22._2();
        Option option = this.handlersByMethodName().get((Object)method2);
        if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.eval((Function0 & Serializable)() -> {
                $this.jsonrpc4s$RpcServer$$logger.info((Function0 & Serializable)() -> new StringBuilder(19).append("Method not found '").append(method2).append("'").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("RpcServer.scala"), new Name("handleRequest"), new Line(70));
                return Response$.MODULE$.methodNotFound(method2, id2);
            });
        } else if (option instanceof Some) {
            Some some = (Some)option;
            NamedJsonRpcService handler = (NamedJsonRpcService)some.value();
            Task response = handler.handle(request).onErrorRecover((PartialFunction)new Serializable(this, request){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ RpcServer $outer;
                private final Request request$2;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    Option option;
                    A1 A1 = x1;
                    if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.$outer.jsonrpc4s$RpcServer$$logger.error((Function0 & Serializable)() -> new StringBuilder(42).append("Unhandled JSON-RPC error handling request ").append($this.request$2).toString(), e, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("RpcServer.scala"), new Name("applyOrElse"), new Line(77));
                        object = Response$.MODULE$.internalError(e.getMessage(), this.request$2.id());
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Option option;
                    Throwable throwable = x1;
                    boolean bl = throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$2 = request$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(jsonrpc4s.RpcServer$$anonfun$1 )}, serializedLambda);
                }
            });
            CancelableFuture runningResponse = response.runToFuture(this.requestScheduler);
            this.activeClientRequests().put((Object)request.id(), (Object)runningResponse);
            task = Task$.MODULE$.fromFuture((Future)runningResponse);
        } else {
            throw new MatchError((Object)option);
        }
        return task;
    }

    public Task<Response> handleNotification(Notification notification) {
        Task task;
        String method;
        Notification notification2 = notification;
        if (notification2 == null) {
            throw new MatchError((Object)notification2);
        }
        String string = method = notification2.method();
        String method2 = string;
        Option option = this.handlersByMethodName().get((Object)method2);
        if (None$.MODULE$.equals(option)) {
            task = Task$.MODULE$.eval((Function0 & Serializable)() -> {
                $this.jsonrpc4s$RpcServer$$logger.error((Function0 & Serializable)() -> new StringBuilder(17).append("Unknown method '").append(method2).append("'").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("RpcServer.scala"), new Name("handleNotification"), new Line(92));
                return Response$None$.MODULE$;
            });
        } else if (option instanceof Some) {
            Some some = (Some)option;
            NamedJsonRpcService handler = (NamedJsonRpcService)some.value();
            Task response = handler.handle(notification).onErrorRecover((PartialFunction)new Serializable(this, notification){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ RpcServer $outer;
                private final Notification notification$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    Option option;
                    A1 A1 = x1;
                    if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.$outer.jsonrpc4s$RpcServer$$logger.error((Function0 & Serializable)() -> new StringBuilder(28).append("Error handling notification ").append($this.notification$1).toString(), e, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("RpcServer.scala"), new Name("applyOrElse"), new Line(101));
                        object = Response$None$.MODULE$;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Option option;
                    Throwable throwable = x1;
                    boolean bl = throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.notification$1 = notification$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(jsonrpc4s.RpcServer$$anonfun$2 )}, serializedLambda);
                }
            });
            task = response.map((Function1 & Serializable)x0$1 -> {
                Response$None$ response$None$;
                Response response = x0$1;
                if (Response$None$.MODULE$.equals(response)) {
                    response$None$ = Response$None$.MODULE$;
                } else {
                    $this.jsonrpc4s$RpcServer$$logger.error((Function0 & Serializable)() -> new StringBuilder(47).append("Obtained non-empty response ").append(response).append(" for notification ").append(notification).append("!").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("RpcServer.scala"), new Name("handleNotification"), new Line(108));
                    response$None$ = Response$None$.MODULE$;
                }
                return response$None$;
            });
        } else {
            throw new MatchError((Object)option);
        }
        return task;
    }

    public Task<Response> handleValidMessage(Message message) {
        Task<Response> task;
        Message message2 = message;
        if (message2 instanceof Response) {
            Response response = (Response)message2;
            task = this.handleResponse(response);
        } else if (message2 instanceof Notification) {
            Notification notification = (Notification)message2;
            task = this.handleNotification(notification);
        } else if (message2 instanceof Request) {
            Request request = (Request)message2;
            task = this.handleRequest(request);
        } else {
            throw new MatchError((Object)message2);
        }
        return task;
    }

    public Task<BoxedUnit> startTask(Task<BoxedUnit> afterSubscribe) {
        return this.in.doAfterSubscribe(afterSubscribe).foreachL((Function1 & Serializable)msg -> {
            RpcServer.$anonfun$startTask$1(this, msg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitForActiveClientRequests$2(Try x$2) {
    }

    public static final /* synthetic */ void $anonfun$startTask$1(RpcServer $this, Message msg) {
        $this.handleValidMessage(msg).map((Function1 & Serializable)x0$1 -> {
            Response response = x0$1;
            Future<Ack> future = Response$None$.MODULE$.equals(response) ? BoxedUnit.UNIT : $this.client.serverRespond(response);
            return future;
        }).onErrorRecover((PartialFunction)new Serializable($this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ RpcServer $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.$outer.jsonrpc4s$RpcServer$$logger.error((Function0 & Serializable)() -> "Unhandled error responding to JSON-RPC client", e, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("RpcServer.scala"), new Name("applyOrElse"), new Line(131));
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                boolean bl = throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3()}, serializedLambda);
            }
        }).runToFuture($this.requestScheduler);
    }

    public RpcServer(Observable<Message> in, RpcClient client, Services services, Scheduler requestScheduler, LoggerSupport logger) {
        this.in = in;
        this.client = client;
        this.requestScheduler = requestScheduler;
        this.jsonrpc4s$RpcServer$$logger = logger;
        this.activeClientRequests = TrieMap$.MODULE$.empty();
        this.cancelNotification = Service$.MODULE$.notification(RpcActions$cancelRequest$.MODULE$, logger, new Service<CancelParams, BoxedUnit>(this){
            private final /* synthetic */ RpcServer $outer;

            public Task<BoxedUnit> handle(CancelParams params) {
                Task task;
                RequestId id = params.id();
                Option option = this.$outer.activeClientRequests().get((Object)id);
                if (None$.MODULE$.equals(option)) {
                    task = Task$.MODULE$.evalAsync((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.$outer.jsonrpc4s$RpcServer$$logger.warn((Function0 & Serializable)() -> new StringBuilder(47).append("Can't cancel request ").append(id).append(", no active request found.").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("RpcServer.scala"), new Name("handle"), new Line(27)));
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CancelableFuture request = (CancelableFuture)some.value();
                    task = Task$.MODULE$.evalAsync((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        $this.$outer.jsonrpc4s$RpcServer$$logger.info((Function0 & Serializable)() -> new StringBuilder(19).append("Cancelling request ").append(id).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("RpcServer.scala"), new Name("handle"), new Line(34));
                        request.cancel();
                        $this.$outer.activeClientRequests().remove((Object)id);
                        Response$.MODULE$.cancelled(id);
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                return task;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handle$1(jsonrpc4s.RpcServer$$anon$1 jsonrpc4s.RequestId ), $anonfun$handle$2(jsonrpc4s.RequestId ), $anonfun$handle$3(jsonrpc4s.RpcServer$$anon$1 jsonrpc4s.RequestId monix.execution.CancelableFuture ), $anonfun$handle$4(jsonrpc4s.RequestId )}, serializedLambda);
            }
        });
        this.handlersByMethodName = services.addService(this.cancelNotification()).byMethodName();
    }
}

