/*
 * Decompiled with CFR 0.152.
 */
package monix.grpc.runtime.server;

import cats.effect.ExitCase;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.CancelablePromise;
import monix.execution.Scheduler;
import monix.grpc.runtime.server.ServerCall$;
import monix.grpc.runtime.server.ServerCallHandlers;
import monix.grpc.runtime.server.ServerCallOptions;
import monix.grpc.runtime.server.ServerCallOptions$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class ServerCallHandlers$ {
    public static final ServerCallHandlers$ MODULE$ = new ServerCallHandlers$();

    public <T, R> ServerCallHandler<T, R> unaryToUnaryCall(Function2<T, Metadata, Task<R>> f, ServerCallOptions options, Scheduler scheduler) {
        return new ServerCallHandler<T, R>(options, scheduler, f){
            private final ServerCallOptions options$1;
            private final Scheduler scheduler$1;
            private final Function2 f$1;

            public ServerCall.Listener<T> startCall(ServerCall<T, R> grpcCall, Metadata metadata) {
                ServerCall<T, R> call = ServerCall$.MODULE$.apply(grpcCall, this.options$1);
                ServerCallHandlers.UnaryCallListener<T, R> listener = new ServerCallHandlers.UnaryCallListener<T, R>(call, this.scheduler$1);
                listener.runUnaryResponseListener(metadata, (Function1 & Serializable)msg -> Task$.MODULE$.defer((Function0 & Serializable)() -> (Task)$this.f$1.apply(msg, (Object)metadata)).flatMap((Function1 & Serializable)message -> ServerCall$.MODULE$.sendMessage$extension(call, message)));
                return listener;
            }
            {
                this.options$1 = options$1;
                this.scheduler$1 = scheduler$1;
                this.f$1 = f$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$startCall$1(monix.grpc.runtime.server.ServerCallHandlers$$anon$1 io.grpc.Metadata io.grpc.ServerCall java.lang.Object ), $anonfun$startCall$2(monix.grpc.runtime.server.ServerCallHandlers$$anon$1 java.lang.Object io.grpc.Metadata ), $anonfun$startCall$3(io.grpc.ServerCall java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <T, R> ServerCallOptions unaryToUnaryCall$default$2() {
        return ServerCallOptions$.MODULE$.default();
    }

    public <T, R> ServerCallHandler<T, R> unaryToStreamingCall(Function2<T, Metadata, Observable<R>> f, ServerCallOptions options, Scheduler scheduler) {
        return new ServerCallHandler<T, R>(options, scheduler, f){
            private final ServerCallOptions options$2;
            private final Scheduler scheduler$2;
            private final Function2 f$2;

            public ServerCall.Listener<T> startCall(ServerCall<T, R> grpcCall, Metadata metadata) {
                ServerCall<T, R> call = ServerCall$.MODULE$.apply(grpcCall, this.options$2);
                ServerCallHandlers.UnaryCallListener<T, R> listener = new ServerCallHandlers.UnaryCallListener<T, R>(call, this.scheduler$2);
                listener.runUnaryResponseListener(metadata, (Function1 & Serializable)msg -> ServerCall$.MODULE$.sendStreamingResponses$extension(call, Observable$.MODULE$.defer((Function0 & Serializable)() -> (Observable)$this.f$2.apply(msg, (Object)metadata)), listener.onReadyEffect()));
                return listener;
            }
            {
                this.options$2 = options$2;
                this.scheduler$2 = scheduler$2;
                this.f$2 = f$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$startCall$4(monix.grpc.runtime.server.ServerCallHandlers$$anon$2 io.grpc.ServerCall io.grpc.Metadata monix.grpc.runtime.server.ServerCallHandlers$UnaryCallListener java.lang.Object ), $anonfun$startCall$5(monix.grpc.runtime.server.ServerCallHandlers$$anon$2 java.lang.Object io.grpc.Metadata )}, serializedLambda);
            }
        };
    }

    public <T, R> ServerCallOptions unaryToStreamingCall$default$2() {
        return ServerCallOptions$.MODULE$.default();
    }

    public <T, R> ServerCallHandler<T, R> streamingToUnaryCall(Function2<Observable<T>, Metadata, Task<R>> f, ServerCallOptions options, Scheduler scheduler) {
        return new ServerCallHandler<T, R>(options, scheduler, f){
            private final ServerCallOptions options$3;
            private final Scheduler scheduler$3;
            private final Function2 f$3;

            public ServerCall.Listener<T> startCall(ServerCall<T, R> grpcCall, Metadata metadata) {
                ServerCall<T, R> call = ServerCall$.MODULE$.apply(grpcCall, this.options$3);
                ServerCallHandlers.StreamingCallListener<T, R> listener = new ServerCallHandlers.StreamingCallListener<T, R>(call, this.options$3.bufferCapacity(), this.scheduler$3);
                listener.runStreamingResponseListener(metadata, (Function1 & Serializable)msgs -> Task$.MODULE$.defer((Function0 & Serializable)() -> (Task)$this.f$3.apply(msgs, (Object)metadata)).flatMap((Function1 & Serializable)message -> ServerCall$.MODULE$.sendMessage$extension(call, message)));
                return listener;
            }
            {
                this.options$3 = options$3;
                this.scheduler$3 = scheduler$3;
                this.f$3 = f$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$startCall$6(monix.grpc.runtime.server.ServerCallHandlers$$anon$3 io.grpc.Metadata io.grpc.ServerCall monix.reactive.Observable ), $anonfun$startCall$7(monix.grpc.runtime.server.ServerCallHandlers$$anon$3 monix.reactive.Observable io.grpc.Metadata ), $anonfun$startCall$8(io.grpc.ServerCall java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <T, R> ServerCallOptions streamingToUnaryCall$default$2() {
        return ServerCallOptions$.MODULE$.default();
    }

    public <T, R> ServerCallHandler<T, R> streamingToStreamingCall(Function2<Observable<T>, Metadata, Observable<R>> f, ServerCallOptions options, Scheduler scheduler) {
        return new ServerCallHandler<T, R>(options, scheduler, f){
            private final ServerCallOptions options$4;
            private final Scheduler scheduler$4;
            private final Function2 f$4;

            public ServerCall.Listener<T> startCall(ServerCall<T, R> grpcCall, Metadata metadata) {
                ServerCall<T, R> call = ServerCall$.MODULE$.apply(grpcCall, this.options$4);
                ServerCallHandlers.StreamingCallListener<T, R> listener = new ServerCallHandlers.StreamingCallListener<T, R>(call, this.options$4.bufferCapacity(), this.scheduler$4);
                listener.runStreamingResponseListener(metadata, (Function1 & Serializable)msgs -> ServerCall$.MODULE$.sendStreamingResponses$extension(call, Observable$.MODULE$.defer((Function0 & Serializable)() -> (Observable)$this.f$4.apply(msgs, (Object)metadata)), listener.onReadyEffect()));
                return listener;
            }
            {
                this.options$4 = options$4;
                this.scheduler$4 = scheduler$4;
                this.f$4 = f$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$startCall$10(monix.grpc.runtime.server.ServerCallHandlers$$anon$4 monix.reactive.Observable io.grpc.Metadata ), $anonfun$startCall$9(monix.grpc.runtime.server.ServerCallHandlers$$anon$4 io.grpc.ServerCall io.grpc.Metadata monix.grpc.runtime.server.ServerCallHandlers$StreamingCallListener monix.reactive.Observable )}, serializedLambda);
            }
        };
    }

    public <T, R> ServerCallOptions streamingToStreamingCall$default$2() {
        return ServerCallOptions$.MODULE$.default();
    }

    public <T, R> Task<BoxedUnit> monix$grpc$runtime$server$ServerCallHandlers$$runResponseHandler(ServerCall<T, R> call, Task<BoxedUnit> handleResponse, CancelablePromise<BoxedUnit> isCancelled) {
        Task finalHandler = handleResponse.guaranteeCase((Function1 & Serializable)x0$1 -> {
            Task<BoxedUnit> task;
            ExitCase exitCase = x0$1;
            if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                task = ServerCall$.MODULE$.closeStream$extension(call, Status.OK, new Metadata());
            } else if (exitCase instanceof ExitCase.Error) {
                ExitCase.Error error = (ExitCase.Error)exitCase;
                Throwable err = (Throwable)error.e();
                task = MODULE$.reportError(err, call, new Metadata());
            } else if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                String description = "Propagating cancellation because server response handler was cancelled!";
                task = ServerCall$.MODULE$.closeStream$extension(call, Status.CANCELLED.withDescription(description), new Metadata());
            } else {
                throw new MatchError((Object)exitCase);
            }
            return task;
        });
        return Task$.MODULE$.race(finalHandler, Task$.MODULE$.fromCancelablePromise(isCancelled)).void();
    }

    private <T, R> Task<BoxedUnit> reportError(Throwable err, ServerCall<T, R> call, Metadata unknownErrorMetadata) {
        Task<BoxedUnit> task;
        Throwable throwable = err;
        if (throwable instanceof StatusException) {
            StatusException statusException = (StatusException)throwable;
            Metadata metadata = (Metadata)Option$.MODULE$.apply((Object)statusException.getTrailers()).getOrElse((Function0 & Serializable)() -> new Metadata());
            task = ServerCall$.MODULE$.closeStream$extension(call, statusException.getStatus(), metadata);
        } else if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            Metadata metadata = (Metadata)Option$.MODULE$.apply((Object)statusRuntimeException.getTrailers()).getOrElse((Function0 & Serializable)() -> new Metadata());
            task = ServerCall$.MODULE$.closeStream$extension(call, statusRuntimeException.getStatus(), metadata);
        } else {
            Status status = Status.INTERNAL.withDescription(throwable.getMessage()).withCause(throwable);
            task = ServerCall$.MODULE$.closeStream$extension(call, status, unknownErrorMetadata);
        }
        return task;
    }

    private ServerCallHandlers$() {
    }
}

