/*
 * Decompiled with CFR 0.152.
 */
package monix.grpc.runtime.client;

import cats.effect.ExitCase;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import monix.eval.Fiber;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.TaskLocal$;
import monix.execution.AsyncVar;
import monix.execution.CancelableFuture;
import monix.execution.Scheduler;
import monix.grpc.runtime.client.ClientCall$;
import monix.grpc.runtime.client.ClientCall$CancelledWithoutCause$;
import monix.grpc.runtime.client.ClientCallListeners;
import monix.grpc.runtime.client.ClientCallListeners$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class ClientCall<Request, Response> {
    private final io.grpc.ClientCall call;

    public static <Request, Response> ClientCall<Request, Response> apply(Channel channel, MethodDescriptor<Request, Response> methodDescriptor, CallOptions callOptions) {
        return ClientCall$.MODULE$.apply(channel, methodDescriptor, callOptions);
    }

    public <Request, Response> ClientCall(io.grpc.ClientCall<Request, Response> call, CallOptions callOptions) {
        this.call = call;
    }

    public io.grpc.ClientCall<Request, Response> call() {
        return this.call;
    }

    public Task<Response> unaryToUnaryCall(Request message, Metadata headers) {
        return Task$.MODULE$.defer(() -> this.unaryToUnaryCall$$anonfun$1(message, headers));
    }

    public Observable<Response> unaryToStreamingCall(Request message, Metadata headers, Scheduler scheduler) {
        return Observable$.MODULE$.defer(() -> this.unaryToStreamingCall$$anonfun$1(message, headers, scheduler));
    }

    public Task<Response> streamingToUnaryCall(Observable<Request> messages, Metadata headers) {
        return Task$.MODULE$.defer(() -> this.streamingToUnaryCall$$anonfun$1(messages, headers));
    }

    private Task<Either<Throwable, BoxedUnit>> sendStreamingRequests(Observable<Request> requests, AsyncVar<BoxedUnit> onReady) {
        return requests.mapEval((Function1 & Serializable)request -> this.call().isReady() ? this.sendMessage(request) : this.sendMessageWhenReady$4(onReady, request)).completedL().guaranteeCase((Function1 & Serializable)x$1 -> {
            Task<BoxedUnit> task;
            ExitCase exitCase = x$1;
            if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                task = this.halfClose();
            } else if (exitCase instanceof ExitCase.Error) {
                Throwable throwable;
                ExitCase.Error error = ExitCase.Error$.MODULE$.unapply((ExitCase.Error)exitCase);
                Throwable e = throwable = (Throwable)error._1();
                task = this.cancel("Caught unexpected client stream error!", (Option<Throwable>)Some$.MODULE$.apply((Object)e));
            } else if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                task = this.cancel("Client stream was canceled!", (Option<Throwable>)None$.MODULE$);
            } else {
                throw new MatchError((Object)exitCase);
            }
            return task;
        }).attempt();
    }

    public Observable<Response> streamingToStreamingCall(Observable<Request> requests, Metadata headers, Scheduler scheduler) {
        return Observable$.MODULE$.defer(() -> this.streamingToStreamingCall$$anonfun$1(requests, headers, scheduler));
    }

    private <R> Task<R> runResponseTaskHandler(Task<R> response) {
        return response.guaranteeCase((Function1 & Serializable)x$1 -> {
            Task<BoxedUnit> task;
            ExitCase exitCase = x$1;
            if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                task = Task$.MODULE$.unit();
            } else if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                task = this.cancel("Client cancelled call " + this.call(), (Option<Throwable>)None$.MODULE$);
            } else if (exitCase instanceof ExitCase.Error) {
                Throwable throwable;
                ExitCase.Error error = ExitCase.Error$.MODULE$.unapply((ExitCase.Error)exitCase);
                Throwable err = throwable = (Throwable)error._1();
                String cancelMsg = "Caught unexpected error when processing response for " + this.call();
                task = this.cancel(cancelMsg, (Option<Throwable>)Some$.MODULE$.apply((Object)err));
            } else {
                throw new MatchError((Object)exitCase);
            }
            return task;
        });
    }

    private <R> Observable<R> runResponseObservableHandler(Observable<R> response) {
        return response.guaranteeCase((Function1 & Serializable)x$1 -> {
            Task<BoxedUnit> task;
            ExitCase exitCase = x$1;
            if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                task = Task$.MODULE$.unit();
            } else if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                task = this.cancel("Client cancelled call " + this.call(), (Option<Throwable>)None$.MODULE$);
            } else if (exitCase instanceof ExitCase.Error) {
                Throwable throwable;
                ExitCase.Error error = ExitCase.Error$.MODULE$.unapply((ExitCase.Error)exitCase);
                Throwable err = throwable = (Throwable)error._1();
                String cancelMsg = "Caught unexpected error when processing response for " + this.call();
                task = this.cancel(cancelMsg, (Option<Throwable>)Some$.MODULE$.apply((Object)err));
            } else {
                throw new MatchError((Object)exitCase);
            }
            return task;
        });
    }

    private <T> Observable<T> isolateObservable(Function0<Observable<T>> thunk) {
        Task subscribingTask = TaskLocal$.MODULE$.isolate(Task$.MODULE$.apply(thunk)).executeWithOptions((Function1 & Serializable)_$9 -> _$9.enableLocalContextPropagation());
        return Observable$.MODULE$.fromTask(subscribingTask).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Task<Nothing$> monix$grpc$runtime$client$ClientCall$$rethrowWithClientCauseIfError(StatusRuntimeException err, Fiber<Either<Throwable, BoxedUnit>> fiber) {
        return fiber.join().timeoutTo(FiniteDuration$.MODULE$.apply(50L, TimeUnit.MILLISECONDS), Task$.MODULE$.apply(ClientCall::rethrowWithClientCauseIfError$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
            Task task;
            Throwable throwable;
            Either either = x$1;
            if (either instanceof Left && (throwable = (Throwable)((Left)either).value()) != null) {
                Throwable clientCallError = throwable;
                Status newStatus = err.getStatus().withCause(clientCallError);
                task = Task$.MODULE$.raiseError((Throwable)newStatus.asRuntimeException(err.getTrailers()));
            } else if (either instanceof Right) {
                task = Task$.MODULE$.raiseError((Throwable)err);
            } else {
                throw new MatchError((Object)either);
            }
            return task;
        });
    }

    private Task<BoxedUnit> start(ClientCall.Listener<Response> listener, Metadata headers) {
        return Task$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.start$$anonfun$1(listener, headers)));
    }

    private Task<BoxedUnit> requestMessagesFromUnaryCall() {
        return this.request(2);
    }

    private Task<BoxedUnit> request(int numMessages) {
        return Task$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.request$$anonfun$1(numMessages)));
    }

    private Task<BoxedUnit> sendMessage(Request message) {
        return Task$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.sendMessage$$anonfun$1(message)));
    }

    private Task<BoxedUnit> halfClose() {
        return Task$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)this::halfClose$$anonfun$1));
    }

    private Task<BoxedUnit> cancel(String message, Option<Throwable> cause) {
        return Task$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.cancel$$anonfun$1(message, cause)));
    }

    private final Task unaryToUnaryCall$$anonfun$1(Object message$1, Metadata headers$1) {
        ClientCallListeners.UnaryClientCallListener listener = ClientCallListeners$.MODULE$.unary();
        Task makeCall = this.start(listener, headers$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return this.requestMessagesFromUnaryCall().flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return this.sendMessage(message$1).guaranteeCase((Function1 & Serializable)x$1 -> {
                    Task<BoxedUnit> task;
                    ExitCase exitCase = x$1;
                    if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                        task = this.halfClose();
                    } else if (exitCase instanceof ExitCase.Error) {
                        Throwable throwable;
                        ExitCase.Error error = ExitCase.Error$.MODULE$.unapply((ExitCase.Error)exitCase);
                        Throwable e = throwable = (Throwable)error._1();
                        task = this.cancel("Caught error when sending client message", (Option<Throwable>)Some$.MODULE$.apply((Object)e));
                    } else if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                        task = this.cancel("Unexpected cancellation when sending client message", (Option<Throwable>)None$.MODULE$);
                    } else {
                        throw new MatchError((Object)exitCase);
                    }
                    return task;
                }).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                    return listener.waitForResponse().map((Function1 & Serializable)response -> response);
                });
            });
        });
        return TaskLocal$.MODULE$.isolate(this.runResponseTaskHandler(makeCall)).executeWithOptions((Function1 & Serializable)_$1 -> _$1.enableLocalContextPropagation());
    }

    private final /* synthetic */ Task $anonfun$7(int numMessages) {
        return this.request(numMessages);
    }

    private final Observable unaryToStreamingCall$$anonfun$3$$anonfun$2(ClientCallListeners.StreamingClientCallListener listener$4, Task startCall$1) {
        return listener$4.incomingResponses().doAfterSubscribe(startCall$1).doOnNext((Function1 & Serializable)_$2 -> this.request(1));
    }

    private final Observable unaryToStreamingCall$$anonfun$1(Object message$4, Metadata headers$2, Scheduler scheduler$1) {
        ClientCallListeners.StreamingClientCallListener listener = ClientCallListeners$.MODULE$.streaming((Function1<Object, Task<BoxedUnit>>)(Function1 & Serializable)numMessages -> this.$anonfun$7(BoxesRunTime.unboxToInt((Object)numMessages)), scheduler$1);
        Task startCall = this.start(listener, headers$2).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return this.request(1).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return this.sendMessage(message$4).guaranteeCase((Function1 & Serializable)x$1 -> {
                    Task<BoxedUnit> task;
                    ExitCase exitCase = x$1;
                    if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                        task = this.halfClose();
                    } else if (exitCase instanceof ExitCase.Error) {
                        Throwable throwable;
                        ExitCase.Error error = ExitCase.Error$.MODULE$.unapply((ExitCase.Error)exitCase);
                        Throwable e = throwable = (Throwable)error._1();
                        task = this.cancel("Caught error when sending client message", (Option<Throwable>)Some$.MODULE$.apply((Object)e));
                    } else if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                        task = this.cancel("Unexpected cancellation when sending client message", (Option<Throwable>)None$.MODULE$);
                    } else {
                        throw new MatchError((Object)exitCase);
                    }
                    return task;
                }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                });
            });
        });
        return this.runResponseObservableHandler(this.isolateObservable(() -> this.unaryToStreamingCall$$anonfun$3$$anonfun$2(listener, startCall)));
    }

    private final Task streamingToUnaryCall$$anonfun$1(Observable messages$1, Metadata headers$3) {
        ClientCallListeners.UnaryClientCallListener listener = ClientCallListeners$.MODULE$.unary();
        Task makeCall = this.start(listener, headers$3).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return this.requestMessagesFromUnaryCall().flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return Task$.MODULE$.racePair(listener.waitForResponse().attempt(), this.sendStreamingRequests(messages$1, listener.onReadyEffect())).flatMap((Function1 & Serializable)runningRequest -> {
                    Option<StatusRuntimeException> option;
                    Throwable throwable;
                    Task task;
                    Tuple2 tuple2;
                    Either either = runningRequest;
                    if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                        Fiber fiber = (Fiber)tuple2._1();
                        Either either2 = (Either)tuple2._2();
                        Fiber responseFiber = fiber;
                        if (either2 instanceof Right) {
                            task = responseFiber.join().flatMap((Function1 & Serializable)_$3 -> Task$.MODULE$.fromEither(_$3));
                            return task.map((Function1 & Serializable)response -> response);
                        }
                        Fiber responseFiber2 = fiber;
                        if (either2 instanceof Left) {
                            Throwable clientCallError = (Throwable)((Left)either2).value();
                            task = responseFiber2.join().flatMap((Function1 & Serializable)_$4 -> Task$.MODULE$.fromEither(_$4)).onErrorRecoverWith((PartialFunction)new Serializable(clientCallError){
                                private final Throwable clientCallError$1;
                                {
                                    this.clientCallError$1 = clientCallError$2;
                                }

                                public final boolean isDefinedAt(Throwable x) {
                                    boolean bl;
                                    Option<StatusRuntimeException> option;
                                    Throwable throwable = x;
                                    if (throwable != null && !(option = ClientCall$CancelledWithoutCause$.MODULE$.unapply(throwable)).isEmpty()) {
                                        StatusRuntimeException statusRuntimeException;
                                        StatusRuntimeException err = statusRuntimeException = (StatusRuntimeException)option.get();
                                        bl = true;
                                    } else {
                                        bl = false;
                                    }
                                    return bl;
                                }

                                public final Object applyOrElse(Throwable x, Function1 function1) {
                                    Object object;
                                    Option<StatusRuntimeException> option;
                                    Throwable throwable = x;
                                    if (throwable != null && !(option = ClientCall$CancelledWithoutCause$.MODULE$.unapply(throwable)).isEmpty()) {
                                        StatusRuntimeException statusRuntimeException;
                                        StatusRuntimeException err = statusRuntimeException = (StatusRuntimeException)option.get();
                                        Status newStatus = err.getStatus().withCause(this.clientCallError$1);
                                        object = Task$.MODULE$.raiseError((Throwable)newStatus.asRuntimeException(err.getTrailers()));
                                    } else {
                                        object = function1.apply((Object)x);
                                    }
                                    return object;
                                }
                            });
                            return task.map((Function1 & Serializable)response -> response);
                        }
                    }
                    if (!(either instanceof Left)) throw new MatchError((Object)either);
                    Tuple2 tuple22 = (Tuple2)((Left)either).value();
                    if (tuple22 == null) throw new MatchError((Object)either);
                    Either either3 = (Either)tuple22._1();
                    if (!(either3 instanceof Either)) throw new MatchError((Object)either);
                    Either response2 = either3;
                    Fiber clientStreamFiber = (Fiber)tuple22._2();
                    Either either4 = response2;
                    if (either4 instanceof Left && (throwable = (Throwable)((Left)either4).value()) != null && !(option = ClientCall$CancelledWithoutCause$.MODULE$.unapply(throwable)).isEmpty()) {
                        StatusRuntimeException statusRuntimeException;
                        StatusRuntimeException err = statusRuntimeException = (StatusRuntimeException)option.get();
                        task = this.monix$grpc$runtime$client$ClientCall$$rethrowWithClientCauseIfError(err, (Fiber<Either<Throwable, BoxedUnit>>)clientStreamFiber).guarantee(clientStreamFiber.cancel());
                        return task.map((Function1 & Serializable)response -> response);
                    }
                    Either response3 = either4;
                    task = clientStreamFiber.cancel().flatMap((Function1 & Serializable)_$5 -> Task$.MODULE$.fromEither(response3));
                    return task.map((Function1 & Serializable)response -> response);
                });
            });
        });
        return TaskLocal$.MODULE$.isolate(this.runResponseTaskHandler(makeCall)).executeWithOptions((Function1 & Serializable)_$6 -> _$6.enableLocalContextPropagation());
    }

    private static final CancelableFuture sendMessageWhenReady$1$$anonfun$1(AsyncVar onReady$2) {
        return onReady$2.take();
    }

    private final Task sendMessageWhenReady$3$$anonfun$3(Object request$1) {
        return this.sendMessage(request$1);
    }

    private final Task sendMessageWhenReady$4(AsyncVar onReady$1, Object request) {
        return Task$.MODULE$.deferFuture(() -> ClientCall.sendMessageWhenReady$1$$anonfun$1(onReady$1)).restartUntil((Function1 & Serializable)_$7 -> this.call().isReady()).$greater$greater(() -> this.sendMessageWhenReady$3$$anonfun$3(request));
    }

    private final /* synthetic */ Task $anonfun$19(int numMessages) {
        return this.request(numMessages);
    }

    private final Task $anonfun$23(Observable requests$2, ClientCallListeners.StreamingClientCallListener listener$7) {
        return this.sendStreamingRequests(requests$2, listener$7.onReadyEffect()).start().map((Function1 & Serializable)sendRequestsFiber -> listener$7.incomingResponses().doAfterSubscribe(this.request(1)).doOnNext((Function1 & Serializable)_$8 -> this.request(1)).onErrorRecoverWith((PartialFunction)new Serializable((Fiber)sendRequestsFiber, this){
            private final Fiber sendRequestsFiber$1;
            private final ClientCall $outer;
            {
                this.sendRequestsFiber$1 = sendRequestsFiber$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                boolean bl;
                Option<StatusRuntimeException> option;
                Throwable throwable = x;
                if (throwable != null && !(option = ClientCall$CancelledWithoutCause$.MODULE$.unapply(throwable)).isEmpty()) {
                    StatusRuntimeException statusRuntimeException;
                    StatusRuntimeException serverCallError = statusRuntimeException = (StatusRuntimeException)option.get();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Object object;
                Option<StatusRuntimeException> option;
                Throwable throwable = x;
                if (throwable != null && !(option = ClientCall$CancelledWithoutCause$.MODULE$.unapply(throwable)).isEmpty()) {
                    StatusRuntimeException statusRuntimeException;
                    StatusRuntimeException serverCallError = statusRuntimeException = (StatusRuntimeException)option.get();
                    object = Observable$.MODULE$.fromTask(this.$outer.monix$grpc$runtime$client$ClientCall$$rethrowWithClientCauseIfError(serverCallError, (Fiber<Either<Throwable, BoxedUnit>>)this.sendRequestsFiber$1));
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        }).guaranteeCase((Function1 & Serializable)x$1 -> {
            Task task;
            ExitCase exitCase = x$1;
            if (ExitCase.Completed$.MODULE$.equals(exitCase)) {
                task = sendRequestsFiber.join().void();
            } else if (ExitCase.Canceled$.MODULE$.equals(exitCase)) {
                task = sendRequestsFiber.cancel();
            } else if (exitCase instanceof ExitCase.Error) {
                Throwable throwable;
                ExitCase.Error error = ExitCase.Error$.MODULE$.unapply((ExitCase.Error)exitCase);
                Throwable err = throwable = (Throwable)error._1();
                task = sendRequestsFiber.cancel();
            } else {
                throw new MatchError((Object)exitCase);
            }
            return task;
        }));
    }

    private static final Observable streamingToStreamingCall$$anonfun$2$$anonfun$1(Task makeCall$1) {
        return Observable$.MODULE$.fromTask(makeCall$1).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final Observable streamingToStreamingCall$$anonfun$1(Observable requests$1, Metadata headers$4, Scheduler scheduler$2) {
        ClientCallListeners.StreamingClientCallListener listener = ClientCallListeners$.MODULE$.streaming((Function1<Object, Task<BoxedUnit>>)(Function1 & Serializable)numMessages -> this.$anonfun$19(BoxesRunTime.unboxToInt((Object)numMessages)), scheduler$2);
        Task makeCall = this.start(listener, headers$4).$greater$greater(() -> this.$anonfun$23(requests$1, listener));
        return this.runResponseObservableHandler(this.isolateObservable(() -> ClientCall.streamingToStreamingCall$$anonfun$2$$anonfun$1(makeCall)));
    }

    private static final Right rethrowWithClientCauseIfError$$anonfun$1() {
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private final void start$$anonfun$1(ClientCall.Listener listener$9, Metadata headers$5) {
        this.call().start(listener$9, headers$5);
    }

    private final void request$$anonfun$1(int numMessages$1) {
        this.call().request(numMessages$1);
    }

    private final void sendMessage$$anonfun$1(Object message$7) {
        this.call().sendMessage(message$7);
    }

    private final void halfClose$$anonfun$1() {
        this.call().halfClose();
    }

    private final void cancel$$anonfun$1(String message$8, Option cause$1) {
        this.call().cancel(message$8, (Throwable)cause$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }
}

