/*
 * Decompiled with CFR 0.152.
 */
package monix.grpc.runtime.client;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Ack;
import monix.execution.AsyncVar;
import monix.execution.AsyncVar$;
import monix.execution.CancelablePromise;
import monix.execution.CancelablePromise$;
import monix.execution.Scheduler;
import monix.execution.schedulers.CanBlock$;
import monix.grpc.runtime.client.ClientCallListeners$;
import monix.grpc.runtime.client.ClientCallListeners$CallStatus$;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.OverflowStrategy;
import monix.reactive.subjects.ConcurrentSubject;
import monix.reactive.subjects.ConcurrentSubject$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClientCallListeners {
    public static <R> StreamingClientCallListener<R> streaming(Function1<Object, Task<BoxedUnit>> function1, Scheduler scheduler) {
        return ClientCallListeners$.MODULE$.streaming(function1, scheduler);
    }

    public static UnaryClientCallListener unary() {
        return ClientCallListeners$.MODULE$.unary();
    }

    public static final class CallStatus
    implements Product,
    Serializable {
        private final Status status;
        private final Metadata trailers;

        public static CallStatus apply(Status status, Metadata metadata) {
            return ClientCallListeners$CallStatus$.MODULE$.apply(status, metadata);
        }

        public static CallStatus fromProduct(Product product) {
            return ClientCallListeners$CallStatus$.MODULE$.fromProduct(product);
        }

        public static CallStatus unapply(CallStatus callStatus) {
            return ClientCallListeners$CallStatus$.MODULE$.unapply(callStatus);
        }

        public CallStatus(Status status, Metadata trailers) {
            this.status = status;
            this.trailers = trailers;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CallStatus)) return false;
            CallStatus callStatus = (CallStatus)object;
            Status status = this.status();
            Status status2 = callStatus.status();
            if (status == null) {
                if (status2 != null) {
                    return false;
                }
            } else if (!status.equals(status2)) return false;
            Metadata metadata = this.trailers();
            Metadata metadata2 = callStatus.trailers();
            if (metadata == null) {
                if (metadata2 == null) return true;
                return false;
            } else {
                if (!metadata.equals(metadata2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CallStatus;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CallStatus";
        }

        public Object productElement(int n) {
            Status status;
            int n2 = n;
            if (0 == n2) {
                status = this._1();
            } else if (1 == n2) {
                status = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return status;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "status";
            } else if (1 == n2) {
                string = "trailers";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Status status() {
            return this.status;
        }

        public Metadata trailers() {
            return this.trailers;
        }

        public boolean isOk() {
            return this.status().isOk();
        }

        public RuntimeException toException() {
            return this.status().asRuntimeException(this.trailers());
        }

        public CallStatus copy(Status status, Metadata trailers) {
            return new CallStatus(status, trailers);
        }

        public Status copy$default$1() {
            return this.status();
        }

        public Metadata copy$default$2() {
            return this.trailers();
        }

        public Status _1() {
            return this.status();
        }

        public Metadata _2() {
            return this.trailers();
        }
    }

    public static final class StreamingClientCallListener<Response>
    extends ClientCall.Listener<Response> {
        private final Scheduler scheduler;
        private Option<Metadata> headers0;
        private final ConcurrentSubject<Response, Response> responses0;
        private final AsyncVar onReadyEffect;

        public <Response> StreamingClientCallListener(Function1<Object, Task<BoxedUnit>> request, Scheduler scheduler) {
            this.scheduler = scheduler;
            this.headers0 = None$.MODULE$;
            this.responses0 = ConcurrentSubject$.MODULE$.apply(MulticastStrategy$.MODULE$.publish(), (OverflowStrategy.Synchronous)OverflowStrategy.Unbounded$.MODULE$, scheduler);
            this.onReadyEffect = AsyncVar$.MODULE$.empty(AsyncVar$.MODULE$.empty$default$1());
        }

        public AsyncVar<BoxedUnit> onReadyEffect() {
            return this.onReadyEffect;
        }

        public Observable<Response> incomingResponses() {
            return this.responses0;
        }

        public void onHeaders(Metadata headers) {
            this.headers0 = Some$.MODULE$.apply((Object)headers);
        }

        public void onMessage(Response message) {
            Task task = Task$.MODULE$.deferFuture(() -> this.$anonfun$1(message));
            task.runSyncUnsafe(task.runSyncUnsafe$default$1(), this.scheduler, CanBlock$.MODULE$.permit());
        }

        public void onReady() {
            this.onReadyEffect().tryPut((Object)BoxedUnit.UNIT);
        }

        public void onClose(Status status, Metadata trailers) {
            if (status.isOk()) {
                this.responses0.onComplete();
            } else {
                this.responses0.onError((Throwable)ClientCallListeners$CallStatus$.MODULE$.apply(status, trailers).toException());
            }
        }

        private final Ack $anonfun$1(Object message$1) {
            return this.responses0.onNext(message$1);
        }
    }

    public static final class UnaryClientCallListener<Response>
    extends ClientCall.Listener<Response> {
        private final CancelablePromise<CallStatus> statusPromise = CancelablePromise$.MODULE$.apply(CancelablePromise$.MODULE$.apply$default$1());
        private Option<Metadata> headers0 = None$.MODULE$;
        private Option<Response> response0 = None$.MODULE$;
        private final AsyncVar onReadyEffect = AsyncVar$.MODULE$.empty(AsyncVar$.MODULE$.empty$default$1());

        public AsyncVar<BoxedUnit> onReadyEffect() {
            return this.onReadyEffect;
        }

        public Task<Response> waitForResponse() {
            return Task$.MODULE$.fromCancelablePromise(this.statusPromise).flatMap((Function1 & Serializable)callStatus -> {
                Task task;
                if (!callStatus.isOk()) {
                    task = Task$.MODULE$.raiseError((Throwable)callStatus.toException());
                } else {
                    Option<Response> option = this.response0;
                    if (option instanceof Some) {
                        Object response = ((Some)option).value();
                        task = Task$.MODULE$.now(response);
                    } else if (None$.MODULE$.equals(option)) {
                        String errMsg = "No value received for unary client call!";
                        Status errStatus = Status.INTERNAL.withDescription(errMsg);
                        task = Task$.MODULE$.raiseError((Throwable)errStatus.asRuntimeException(callStatus.trailers()));
                    } else {
                        throw new MatchError(option);
                    }
                }
                return task;
            });
        }

        public void onHeaders(Metadata headers) {
            this.headers0 = Some$.MODULE$.apply((Object)headers);
        }

        public void onMessage(Response message) {
            Option<Response> option = this.response0;
            if (None$.MODULE$.equals(option)) {
                this.response0 = Option$.MODULE$.apply(message);
            } else if (option instanceof Some) {
                String errMsg = "Too many response messages, expected only one!";
                Status errStatus = Status.INTERNAL.withDescription(errMsg);
                Metadata trailers = (Metadata)this.headers0.getOrElse(this::$anonfun$1);
                this.statusPromise.trySuccess((Object)ClientCallListeners$CallStatus$.MODULE$.apply(errStatus, trailers));
            } else {
                throw new MatchError(option);
            }
        }

        public void onReady() {
            this.onReadyEffect().tryPut((Object)BoxedUnit.UNIT);
        }

        public void onClose(Status status, Metadata trailers) {
            this.statusPromise.trySuccess((Object)ClientCallListeners$CallStatus$.MODULE$.apply(status, trailers));
        }

        private final Metadata $anonfun$1() {
            return new Metadata();
        }
    }
}

