/*
 * Decompiled with CFR 0.152.
 */
package monix.grpc.runtime.server;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.TaskLocal$;
import monix.execution.Ack;
import monix.execution.AsyncVar;
import monix.execution.AsyncVar$;
import monix.execution.BufferCapacity;
import monix.execution.CancelablePromise;
import monix.execution.CancelablePromise$;
import monix.execution.Scheduler;
import monix.execution.schedulers.CanBlock$;
import monix.grpc.runtime.server.ServerCall$;
import monix.grpc.runtime.server.ServerCallHandlers$;
import monix.grpc.runtime.server.ServerCallOptions;
import monix.reactive.MulticastStrategy$;
import monix.reactive.Observable;
import monix.reactive.OverflowStrategy;
import monix.reactive.subjects.ConcurrentSubject;
import monix.reactive.subjects.ConcurrentSubject$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public final class ServerCallHandlers {
    public static <T, R> ServerCallHandler<T, R> streamingToStreamingCall(Function2<Observable<T>, Metadata, Observable<R>> function2, ServerCallOptions serverCallOptions, Scheduler scheduler) {
        return ServerCallHandlers$.MODULE$.streamingToStreamingCall(function2, serverCallOptions, scheduler);
    }

    public static <T, R> ServerCallHandler<T, R> streamingToUnaryCall(Function2<Observable<T>, Metadata, Task<R>> function2, ServerCallOptions serverCallOptions, Scheduler scheduler) {
        return ServerCallHandlers$.MODULE$.streamingToUnaryCall(function2, serverCallOptions, scheduler);
    }

    public static <T, R> ServerCallHandler<T, R> unaryToStreamingCall(Function2<T, Metadata, Observable<R>> function2, ServerCallOptions serverCallOptions, Scheduler scheduler) {
        return ServerCallHandlers$.MODULE$.unaryToStreamingCall(function2, serverCallOptions, scheduler);
    }

    public static <T, R> ServerCallHandler<T, R> unaryToUnaryCall(Function2<T, Metadata, Task<R>> function2, ServerCallOptions serverCallOptions, Scheduler scheduler) {
        return ServerCallHandlers$.MODULE$.unaryToUnaryCall(function2, serverCallOptions, scheduler);
    }

    public static ServerCallOptions streamingToStreamingCall$default$2() {
        return ServerCallHandlers$.MODULE$.streamingToStreamingCall$default$2();
    }

    public static ServerCallOptions streamingToUnaryCall$default$2() {
        return ServerCallHandlers$.MODULE$.streamingToUnaryCall$default$2();
    }

    public static ServerCallOptions unaryToStreamingCall$default$2() {
        return ServerCallHandlers$.MODULE$.unaryToStreamingCall$default$2();
    }

    public static ServerCallOptions unaryToUnaryCall$default$2() {
        return ServerCallHandlers$.MODULE$.unaryToUnaryCall$default$2();
    }

    public static final class StreamingCallListener<Request, Response>
    extends ServerCall.Listener<Request> {
        private final ServerCall call;
        private final Scheduler scheduler;
        private final CancelablePromise<BoxedUnit> isCancelled;
        private final ConcurrentSubject<Request, Request> subject;
        private final AsyncVar onReadyEffect;

        public <Request, Response> StreamingCallListener(ServerCall call, BufferCapacity capacity, Scheduler scheduler) {
            this.call = call;
            this.scheduler = scheduler;
            this.isCancelled = CancelablePromise$.MODULE$.apply(CancelablePromise$.MODULE$.apply$default$1());
            this.subject = ConcurrentSubject$.MODULE$.apply(MulticastStrategy$.MODULE$.publish(), (OverflowStrategy.Synchronous)OverflowStrategy.Unbounded$.MODULE$, scheduler);
            this.onReadyEffect = AsyncVar$.MODULE$.empty(AsyncVar$.MODULE$.empty$default$1());
        }

        public AsyncVar<BoxedUnit> onReadyEffect() {
            return this.onReadyEffect;
        }

        public void runStreamingResponseListener(Metadata metadata, Function1<Observable<Request>, Task<BoxedUnit>> sendResponses) {
            Task handleResponse = ServerCall$.MODULE$.sendHeaders$extension(this.call, metadata).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return ((Task)sendResponses.apply((Object)this.subject.doAfterSubscribe(ServerCall$.MODULE$.request$extension(this.call, 1)).doOnNext((Function1 & Serializable)_$2 -> ServerCall$.MODULE$.request$extension(this.call, 1)))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                });
            });
            TaskLocal$.MODULE$.isolate(ServerCallHandlers$.MODULE$.monix$grpc$runtime$server$ServerCallHandlers$$$runResponseHandler(this.call, (Task<BoxedUnit>)handleResponse, this.isCancelled)).executeWithOptions((Function1 & Serializable)_$3 -> _$3.enableLocalContextPropagation()).runAsyncAndForget(this.scheduler);
        }

        public void onCancel() {
            this.isCancelled.trySuccess((Object)BoxedUnit.UNIT);
        }

        public void onHalfClose() {
            this.subject.onComplete();
        }

        public void onMessage(Request msg) {
            Task task = Task$.MODULE$.deferFuture(() -> this.$anonfun$2(msg));
            task.runSyncUnsafe(task.runSyncUnsafe$default$1(), this.scheduler, CanBlock$.MODULE$.permit());
        }

        public void onComplete() {
            this.subject.onComplete();
        }

        public void onReady() {
            this.onReadyEffect().tryPut((Object)BoxedUnit.UNIT);
        }

        private final Ack $anonfun$2(Object msg$3) {
            return this.subject.onNext(msg$3);
        }
    }

    public static final class UnaryCallListener<T, R>
    extends ServerCall.Listener<T> {
        private final ServerCall call;
        private final Scheduler scheduler;
        private final AsyncVar onReadyEffect;
        private Option<T> requestMsg;
        private final CancelablePromise<Status> completed;
        private final CancelablePromise<BoxedUnit> isCancelled;

        public <T, R> UnaryCallListener(ServerCall call, Scheduler scheduler) {
            this.call = call;
            this.scheduler = scheduler;
            this.onReadyEffect = AsyncVar$.MODULE$.empty(AsyncVar$.MODULE$.empty$default$1());
            this.requestMsg = None$.MODULE$;
            this.completed = CancelablePromise$.MODULE$.apply(CancelablePromise$.MODULE$.apply$default$1());
            this.isCancelled = CancelablePromise$.MODULE$.apply(CancelablePromise$.MODULE$.apply$default$1());
        }

        public AsyncVar<BoxedUnit> onReadyEffect() {
            return this.onReadyEffect;
        }

        public void runUnaryResponseListener(Metadata metadata, Function1<T, Task<BoxedUnit>> sendResponse) {
            Task handleResponse = ServerCall$.MODULE$.requestMessagesFromUnaryCall$extension(this.call).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return Task$.MODULE$.fromCancelablePromise(this.completed).flatMap((Function1 & Serializable)x$1 -> {
                    Status status = x$1;
                    return ServerCall$.MODULE$.sendHeaders$extension(this.call, metadata).flatMap((Function1 & Serializable)x$12 -> {
                        Task task;
                        BoxedUnit boxedUnit = x$12;
                        Option<T> option = this.requestMsg;
                        if (option instanceof Some) {
                            Object msg = ((Some)option).value();
                            task = (Task)sendResponse.apply(msg);
                        } else if (None$.MODULE$.equals(option)) {
                            String errMsg = "Missing request message for unary call!";
                            Status errStatus = Status.INTERNAL.withDescription(errMsg);
                            task = Task$.MODULE$.raiseError((Throwable)errStatus.asRuntimeException(metadata));
                        } else {
                            throw new MatchError(option);
                        }
                        return task.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = x$1;
                        });
                    });
                });
            });
            TaskLocal$.MODULE$.isolate(ServerCallHandlers$.MODULE$.monix$grpc$runtime$server$ServerCallHandlers$$$runResponseHandler(this.call, (Task<BoxedUnit>)handleResponse, this.isCancelled)).executeWithOptions((Function1 & Serializable)_$1 -> _$1.enableLocalContextPropagation()).runAsyncAndForget(this.scheduler);
        }

        public void onHalfClose() {
            this.completed.trySuccess((Object)Status.OK);
        }

        public void onCancel() {
            this.isCancelled.trySuccess((Object)BoxedUnit.UNIT);
        }

        public void onMessage(T msg) {
            Option<T> option = this.requestMsg;
            if (None$.MODULE$.equals(option)) {
                this.requestMsg = Option$.MODULE$.apply(msg);
            } else if (option instanceof Some) {
                Object msg2 = ((Some)option).value();
                String errMsg = "Too many requests received for unary request";
                Status errStatus = Status.INTERNAL.withDescription(errMsg);
                this.completed.tryFailure((Throwable)errStatus.asRuntimeException());
            } else {
                throw new MatchError(option);
            }
        }

        public void onReady() {
            this.onReadyEffect().tryPut((Object)BoxedUnit.UNIT);
        }
    }
}

