/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.chatapi.qq;

import java.io.File;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import me.xuxiaoxiao.chatapi.qq.QQAPI;
import me.xuxiaoxiao.chatapi.qq.QQContacts;
import me.xuxiaoxiao.chatapi.qq.QQTools;
import me.xuxiaoxiao.chatapi.qq.entity.contact.QQCategory;
import me.xuxiaoxiao.chatapi.qq.entity.contact.QQContact;
import me.xuxiaoxiao.chatapi.qq.entity.contact.QQDiscuss;
import me.xuxiaoxiao.chatapi.qq.entity.contact.QQGroup;
import me.xuxiaoxiao.chatapi.qq.entity.contact.QQUser;
import me.xuxiaoxiao.chatapi.qq.entity.message.QQMessage;
import me.xuxiaoxiao.chatapi.qq.entity.message.QQText;
import me.xuxiaoxiao.chatapi.qq.entity.message.QQUnknown;
import me.xuxiaoxiao.chatapi.qq.protocol.BaseRsp;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultGetDiscuInfo;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultGetDiscusList;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultGetGroupInfo;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultGetGroupNameListMask;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultGetOnlineBuddies;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultGetRecentList;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultGetUserFriends;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultLongNick;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultPoll;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultUser;
import me.xuxiaoxiao.chatapi.qq.protocol.RspQRLogin;
import me.xuxiaoxiao.xtools.common.XTools;

public class QQClient {
    public static final String LOGIN_EXCEPTION = "\u767b\u9646\u5f02\u5e38";
    public static final String INIT_EXCEPTION = "\u521d\u59cb\u5316\u5f02\u5e38";
    public static final String LISTEN_EXCEPTION = "\u76d1\u542c\u5f02\u5e38";
    public static final String STATUS_AWAY = "away";
    public static final String STATUS_ONLINE = "online";
    public static final String STATUS_CALLME = "callme";
    public static final String STATUS_BUSY = "busy";
    public static final String STATUS_SILENT = "silent";
    public static final String STATUS_HIDDEN = "hidden";
    public static final String STATUS_OFFLINE = "offline";
    private final QQAPI qqAPI = new QQAPI();
    private final QQThread qqThread = new QQThread();
    private final QQContacts qqContacts = new QQContacts();
    private final File folder;
    private final QQChatListener qqChatListener;
    private String checkSig;

    public QQClient(QQChatListener qqChatListener) {
        this(qqChatListener, null, null);
    }

    public QQClient(QQChatListener qqChatListener, File folder, Handler handler) {
        Objects.requireNonNull(qqChatListener);
        if (folder == null) {
            folder = new File("");
        }
        if (handler == null) {
            handler = new ConsoleHandler();
            handler.setLevel(Level.FINER);
        }
        this.qqChatListener = qqChatListener;
        this.folder = folder;
        QQTools.LOGGER.setLevel(handler.getLevel());
        QQTools.LOGGER.setUseParentHandlers(false);
        QQTools.LOGGER.addHandler(handler);
    }

    public void startup() {
        this.qqThread.start();
    }

    public boolean isWorking() {
        return !this.qqThread.isInterrupted();
    }

    public void shutdown() {
        this.qqThread.interrupt();
    }

    public QQUser userMe() {
        return this.qqContacts.me;
    }

    public QQUser userFriend(Long userId) {
        return this.qqContacts.friends.get(userId);
    }

    public HashMap<Long, QQUser> userFriends() {
        return this.qqContacts.friends;
    }

    public QQGroup userGroup(Long groupId) {
        return this.qqContacts.groups.get(groupId);
    }

    public HashMap<Long, QQGroup> userGroups() {
        return this.qqContacts.groups;
    }

    public QQDiscuss userDiscuss(Long discussId) {
        return this.qqContacts.discusses.get(discussId);
    }

    public HashMap<Long, QQDiscuss> userDiscuss() {
        return this.qqContacts.discusses;
    }

    public ArrayList<QQCategory> userCategories() {
        return this.qqContacts.categories;
    }

    public void sendText(QQContact contact, String content) {
        if (contact instanceof QQUser) {
            QQTools.LOGGER.fine(String.format("\u5411\u597d\u53cb\u3010%s\u3011\u53d1\u9001\u6d88\u606f\uff1a%s", contact.name, content));
            this.qqAPI.send_buddy_msg2(contact.id, content);
        } else if (contact instanceof QQGroup) {
            QQTools.LOGGER.fine(String.format("\u5411\u7fa4\u3010%s\u3011\u53d1\u9001\u6d88\u606f\uff1a%s", contact.name, content));
            this.qqAPI.send_qun_msg2(contact.id, content);
        } else if (contact instanceof QQDiscuss) {
            QQTools.LOGGER.fine(String.format("\u5411\u8ba8\u8bba\u7ec4\u3010%s\u3011\u53d1\u9001\u6d88\u606f\uff1a%s", contact.name, content));
            this.qqAPI.send_discu_msg2(contact.id, content);
        } else {
            QQTools.LOGGER.fine(String.format("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u8054\u7cfb\u4eba\u3010%s\u3011\u7684\u7c7b\u578b\u672a\u77e5", contact.name));
        }
    }

    public void changeStatus(String status) {
        QQTools.LOGGER.fine(String.format("\u6539\u53d8\u6211\u7684\u5728\u7ebf\u72b6\u6001\u4e3a\u3010%s\u3011", status));
        this.qqAPI.change_status2(status);
    }

    private class QQThread
    extends Thread {
        private QQThread() {
        }

        @Override
        public void run() {
            int loginCount = 0;
            while (!this.isInterrupted()) {
                QQTools.LOGGER.finer(String.format("\u6b63\u5728\u8fdb\u884c\u7b2c%d\u6b21\u767b\u5f55", loginCount));
                String loginErr = this.login();
                if (!XTools.strEmpty((String)loginErr)) {
                    QQClient.this.qqChatListener.onException(loginErr);
                    return;
                }
                QQTools.LOGGER.finer("\u6b63\u5728\u521d\u59cb\u5316");
                String initErr = this.initial();
                if (!XTools.strEmpty((String)initErr)) {
                    QQClient.this.qqChatListener.onException(initErr);
                    return;
                }
                QQClient.this.qqChatListener.onLogin();
                QQTools.LOGGER.finer("\u6b63\u5728\u76d1\u542c\u6d88\u606f");
                String listenErr = this.listen();
                if (!XTools.strEmpty((String)listenErr)) {
                    if (loginCount++ <= 70) continue;
                    QQClient.this.qqChatListener.onException(listenErr);
                    return;
                }
                QQTools.LOGGER.finer("\u6b63\u5728\u9000\u51fa\u767b\u5f55");
                QQClient.this.qqChatListener.onLogout();
                return;
            }
        }

        private String login() {
            try {
                QQClient.this.qqAPI.xlogin();
                for (HttpCookie cookie : ((QQClient)QQClient.this).qqAPI.httpOption.cookieManager.getCookieStore().getCookies()) {
                    if (!"pt_login_sig".equals(cookie.getName())) continue;
                    ((QQClient)QQClient.this).qqAPI.pt_login_sig = cookie.getValue();
                }
                if (XTools.strEmpty((String)QQClient.this.checkSig)) {
                    QQClient.this.qqChatListener.onQRCode(QQClient.this.qqAPI.ptqrshow(String.format("%s%sqrcode-%d-%d.jpg", QQClient.this.folder.getAbsolutePath(), File.separator, System.currentTimeMillis(), (int)(Math.random() * 1000.0))));
                    for (HttpCookie cookie : ((QQClient)QQClient.this).qqAPI.httpOption.cookieManager.getCookieStore().getCookies()) {
                        if (!"qrsig".equals(cookie.getName())) continue;
                        ((QQClient)QQClient.this).qqAPI.qrsig = cookie.getValue();
                        break;
                    }
                    block9: while (true) {
                        Thread.sleep(2000L);
                        RspQRLogin rspQRLogin = QQClient.this.qqAPI.ptqrlogin();
                        switch (rspQRLogin.code) {
                            case 0: {
                                QQTools.LOGGER.finer("\u5df2\u6388\u6743\u767b\u5f55");
                                QQClient.this.checkSig = rspQRLogin.uri;
                                QQClient.this.qqAPI.check_sig(rspQRLogin.uri);
                                return null;
                            }
                            case 66: {
                                QQTools.LOGGER.finer("\u7b49\u5f85\u64cd\u4f5c\u4e2d");
                                continue block9;
                            }
                            case 67: {
                                QQTools.LOGGER.finer("\u7b49\u5f85\u6388\u6743\u767b\u5f55");
                                continue block9;
                            }
                        }
                        break;
                    }
                    QQTools.LOGGER.finer("\u4e8c\u7ef4\u7801\u5df2\u5931\u6548");
                    return QQClient.LOGIN_EXCEPTION;
                }
                QQClient.this.qqAPI.check_sig(QQClient.this.checkSig);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                QQTools.LOGGER.severe(String.format("\u767b\u5f55\u5f02\u5e38\uff1a%s\n%s", e.getMessage(), Arrays.toString(e.getStackTrace())));
                return QQClient.LOGIN_EXCEPTION;
            }
        }

        private String initial() {
            try {
                QQClient.this.qqAPI.getvfwebqq();
                QQClient.this.qqAPI.login2();
                ((QQClient)QQClient.this).qqContacts.me = ((ResultUser)((QQClient)QQClient.this).qqAPI.get_self_info2().result).convert();
                QQTools.LOGGER.finer(String.format("\u83b7\u53d6\u5230\u81ea\u8eab\u4fe1\u606f\uff1a%s", QQTools.GSON.toJson((Object)((QQClient)QQClient.this).qqContacts.me)));
                ((QQClient)QQClient.this).qqContacts.categories = ((ResultGetUserFriends)((QQClient)QQClient.this).qqAPI.get_user_friends2().result).convert();
                for (QQCategory qQCategory : ((QQClient)QQClient.this).qqContacts.categories) {
                    ((QQClient)QQClient.this).qqContacts.friends.putAll(qQCategory.friends);
                }
                QQTools.LOGGER.finer(String.format("\u83b7\u53d6\u5230\u597d\u53cb %d \u4e2a", ((QQClient)QQClient.this).qqContacts.friends.size()));
                ((QQClient)QQClient.this).qqContacts.groups.putAll(((ResultGetGroupNameListMask)((QQClient)QQClient.this).qqAPI.get_group_name_list_mask2().result).convert());
                QQTools.LOGGER.finer(String.format("\u83b7\u53d6\u5230\u7fa4 %d \u4e2a", ((QQClient)QQClient.this).qqContacts.groups.size()));
                ((QQClient)QQClient.this).qqContacts.discusses.putAll(((ResultGetDiscusList)((QQClient)QQClient.this).qqAPI.get_discus_list().result).convert());
                QQTools.LOGGER.finer(String.format("\u83b7\u53d6\u5230\u8ba8\u8bba\u7ec4 %d \u4e2a", ((QQClient)QQClient.this).qqContacts.discusses.size()));
                ResultGetOnlineBuddies resultOnline = (ResultGetOnlineBuddies)((QQClient)QQClient.this).qqAPI.get_online_buddies2().result;
                if (resultOnline != null) {
                    for (ResultGetOnlineBuddies.OnlineBuddy onlineBuddy : resultOnline) {
                        if (!((QQClient)QQClient.this).qqContacts.friends.containsKey(onlineBuddy.uin)) continue;
                        ((QQClient)QQClient.this).qqContacts.friends.get((Object)Long.valueOf((long)onlineBuddy.uin)).status = onlineBuddy.status;
                    }
                }
                ((QQClient)QQClient.this).qqContacts.recent = new ArrayList();
                ResultGetRecentList resultGetRecentList = (ResultGetRecentList)((QQClient)QQClient.this).qqAPI.get_recent_list2().result;
                if (resultGetRecentList != null) {
                    for (ResultGetRecentList.Recent recent : resultGetRecentList) {
                        if (recent.type == 0) {
                            ((QQClient)QQClient.this).qqContacts.recent.add(((QQClient)QQClient.this).qqContacts.friends.get(recent.uin));
                            continue;
                        }
                        if (recent.type == 1) {
                            ((QQClient)QQClient.this).qqContacts.recent.add(((QQClient)QQClient.this).qqContacts.groups.get(recent.uin));
                            continue;
                        }
                        if (recent.type != 2) continue;
                        ((QQClient)QQClient.this).qqContacts.recent.add(((QQClient)QQClient.this).qqContacts.discusses.get(recent.uin));
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                QQTools.LOGGER.severe(String.format("\u521d\u59cb\u5316\u5f02\u5e38\uff1a%s\n%s", e.getMessage(), Arrays.toString(e.getStackTrace())));
                return QQClient.INIT_EXCEPTION;
            }
        }

        private String listen() {
            try {
                long lastEmpty = 0L;
                int emptyCount = 0;
                int retryCount = 0;
                while (!this.isInterrupted()) {
                    try {
                        BaseRsp<ResultPoll> rspPoll = QQClient.this.qqAPI.poll2();
                        if (rspPoll.result != null) {
                            for (ResultPoll.Item item : (ResultPoll)rspPoll.result) {
                                QQMessage qqMessage;
                                try {
                                    switch (item.poll_type) {
                                        case "message": {
                                            ResultUser resultUser;
                                            QQUser qqUser;
                                            QQUser qQUser = qqUser = item.value.from_uin == ((QQClient)QQClient.this).qqContacts.me.id ? ((QQClient)QQClient.this).qqContacts.me : ((QQClient)QQClient.this).qqContacts.friends.get(item.value.from_uin);
                                            if (!(qqUser != null && qqUser.isDetail || (resultUser = (ResultUser)((QQClient)QQClient.this).qqAPI.get_friend_info2((long)item.value.from_uin).result) == null)) {
                                                qqUser = resultUser.convert();
                                                ArrayList signatures = (ArrayList)((QQClient)QQClient.this).qqAPI.get_single_long_nick2((long)qqUser.id).result;
                                                if (signatures != null && signatures.size() > 0) {
                                                    qqUser.signature = ((ResultLongNick)signatures.get((int)0)).lnick;
                                                }
                                                ((QQClient)QQClient.this).qqContacts.friends.put(qqUser.id, qqUser);
                                            }
                                            qqMessage = this.parseCommon(item.value, new QQText());
                                            break;
                                        }
                                        case "group_message": {
                                            QQGroup qqGroup = ((QQClient)QQClient.this).qqContacts.groups.get(item.value.group_code);
                                            if (qqGroup == null) {
                                                QQTools.LOGGER.warning("\u68c0\u6d4b\u5230\u672a\u77e5\u7684\u7fa4\uff0c\u9700\u8981\u91cd\u65b0\u521d\u59cb\u5316");
                                                return QQClient.LISTEN_EXCEPTION;
                                            }
                                            if (qqGroup.members == null || !qqGroup.members.containsKey(item.value.send_uin)) {
                                                qqGroup = ((ResultGetGroupInfo)((QQClient)QQClient.this).qqAPI.get_group_info_ext2((long)qqGroup.code).result).convert();
                                                ((QQClient)QQClient.this).qqContacts.groups.put(qqGroup.id, qqGroup);
                                            }
                                            qqMessage = this.parseCommon(item.value, new QQText());
                                            break;
                                        }
                                        case "discu_message": {
                                            ResultGetDiscuInfo resultGetDiscuInfo;
                                            QQDiscuss qqDiscuss = ((QQClient)QQClient.this).qqContacts.discusses.get(item.value.did);
                                            if (!(qqDiscuss != null && qqDiscuss.members != null && qqDiscuss.members.containsKey(item.value.send_uin) || (resultGetDiscuInfo = (ResultGetDiscuInfo)((QQClient)QQClient.this).qqAPI.get_discu_info((long)item.value.did).result) == null)) {
                                                qqDiscuss = resultGetDiscuInfo.convert();
                                                ((QQClient)QQClient.this).qqContacts.discusses.put(qqDiscuss.id, qqDiscuss);
                                            }
                                            qqMessage = this.parseCommon(item.value, new QQText());
                                            break;
                                        }
                                        default: {
                                            qqMessage = this.parseCommon(item.value, new QQUnknown());
                                            break;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    QQTools.LOGGER.warning(String.format("\u89e3\u6790\u6d88\u606f\u51fa\u9519\uff1a%s\n%s", e.getMessage(), Arrays.toString(e.getStackTrace())));
                                    qqMessage = this.parseCommon(item.value, new QQUnknown());
                                }
                                if (qqMessage instanceof QQText) {
                                    if (qqMessage.fromGroup != null) {
                                        if (qqMessage.fromGroupMember.id == ((QQClient)QQClient.this).qqContacts.me.id) {
                                            QQTools.LOGGER.fine(String.format("\u6211\u5728\u7fa4\u3010%s\u3011\u91cc\u8bf4\uff1a%s", qqMessage.fromGroup.name, qqMessage.content));
                                        } else {
                                            QQTools.LOGGER.fine(String.format("\u7fa4\u3010%s\u3011\u91cc\u7684\u3010%s\u3011\u8bf4\uff1a%s", qqMessage.fromGroup.name, qqMessage.fromGroupMember.name, qqMessage.content));
                                        }
                                    }
                                    if (qqMessage.fromDiscuss != null) {
                                        if (qqMessage.fromDiscussMember.id == ((QQClient)QQClient.this).qqContacts.me.id) {
                                            QQTools.LOGGER.fine(String.format("\u6211\u5728\u8ba8\u8bba\u7ec4\u3010%s\u3011\u91cc\u8bf4\uff1a%s", qqMessage.fromDiscuss.name, qqMessage.content));
                                        } else {
                                            QQTools.LOGGER.fine(String.format("\u8ba8\u8bba\u7ec4\u3010%s\u3011\u91cc\u7684\u3010%s\u3011\u8bf4\uff1a%s", qqMessage.fromDiscuss.name, qqMessage.fromDiscussMember.name, qqMessage.content));
                                        }
                                    }
                                    if (qqMessage.fromUser != null) {
                                        if (qqMessage.fromUser.id == ((QQClient)QQClient.this).qqContacts.me.id) {
                                            QQTools.LOGGER.fine(String.format("\u6211\u5bf9\u597d\u53cb\u3010%s\u3011\u8bf4\uff1a%s", qqMessage.toUser.name, qqMessage.content));
                                        } else {
                                            QQTools.LOGGER.fine(String.format("\u597d\u53cb\u3010%s\u3011\u5bf9\u6211\u8bf4\uff1a%s", qqMessage.fromUser.name, qqMessage.content));
                                        }
                                    }
                                    QQClient.this.qqChatListener.onMessage(qqMessage);
                                    continue;
                                }
                                if (qqMessage == null) continue;
                                QQTools.LOGGER.fine("\u6536\u5230\u4e86\u672a\u77e5\u7c7b\u578b\u7684\u6d88\u606f");
                                QQClient.this.qqChatListener.onMessage(qqMessage);
                            }
                            emptyCount = 0;
                        } else {
                            if (System.currentTimeMillis() - lastEmpty < 7000L) {
                                ++emptyCount;
                            }
                            if (emptyCount > 7) {
                                QQTools.LOGGER.severe("\u8fde\u63a5\u5df2\u5931\u6548\uff1a\u5feb\u901f\u7a7a\u8f6e\u8be2\u8fc7\u591a");
                                return QQClient.LISTEN_EXCEPTION;
                            }
                            QQTools.LOGGER.finer("\u6682\u65e0\u4fe1\u606f");
                            lastEmpty = System.currentTimeMillis();
                        }
                        retryCount = 0;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (retryCount++ < 5) {
                            QQTools.LOGGER.warning(String.format("\u76d1\u542c\u6216\u89e3\u6790\u5931\u8d25\uff0c\u91cd\u8bd5\u7b2c%d\u6b21", retryCount));
                            continue;
                        }
                        QQTools.LOGGER.severe(String.format("\u76d1\u542c\u6216\u89e3\u6790\u5931\u8d25\uff1a%s\n%s", e.getMessage(), Arrays.toString(e.getStackTrace())));
                        QQTools.LOGGER.severe("\u8fde\u63a5\u5df2\u5931\u6548\uff1a\u76d1\u542c\u6216\u89e3\u6790\u91cd\u8bd5\u6b21\u6570\u8fc7\u591a");
                        return QQClient.LISTEN_EXCEPTION;
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                QQTools.LOGGER.severe(String.format("\u76d1\u542c\u5f02\u5e38\uff1a%s\n%s", e.getMessage(), Arrays.toString(e.getStackTrace())));
                return QQClient.LISTEN_EXCEPTION;
            }
        }

        private <T extends QQMessage> T parseCommon(ResultPoll.Item.Message message, T t) {
            t.id = message.msg_id;
            if (message.group_code > 0L) {
                t.fromGroup = ((QQClient)QQClient.this).qqContacts.groups.get(message.group_code);
                QQGroup.Member member = t.fromGroup != null ? (t.fromGroup.members != null ? t.fromGroup.members.get(message.send_uin) : null) : (t.fromGroupMember = null);
            }
            if (message.did > 0L) {
                t.fromDiscuss = ((QQClient)QQClient.this).qqContacts.discusses.get(message.did);
                QQDiscuss.Member member = t.fromDiscuss != null ? (t.fromDiscuss.members != null ? t.fromDiscuss.members.get(message.send_uin) : null) : (t.fromDiscussMember = null);
            }
            if (t.fromGroup == null && t.fromDiscuss == null) {
                t.fromUser = message.from_uin == ((QQClient)QQClient.this).qqContacts.me.id ? ((QQClient)QQClient.this).qqContacts.me : ((QQClient)QQClient.this).qqContacts.friends.get(message.from_uin);
            }
            t.toUser = message.to_uin == ((QQClient)QQClient.this).qqContacts.me.id ? ((QQClient)QQClient.this).qqContacts.me : ((QQClient)QQClient.this).qqContacts.friends.get(message.to_uin);
            t.timestamp = message.time * 1000L;
            StringBuilder sbContent = new StringBuilder();
            for (int i = 1; i < message.content.size(); ++i) {
                if (sbContent.length() > 0) {
                    sbContent.append(" ");
                }
                sbContent.append(message.content.get(i));
            }
            t.content = sbContent.toString();
            return t;
        }
    }

    public static abstract class QQChatListener {
        public abstract void onQRCode(File var1);

        public void onAvatar(String base64Avatar) {
        }

        public void onLogin() {
        }

        public void onMessage(QQMessage qqMessage) {
        }

        public void onLogout() {
        }

        public void onException(String reason) {
        }
    }
}

