/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.chatapi.qq;

import java.io.File;
import java.util.Scanner;
import me.xuxiaoxiao.chatapi.qq.QQClient;
import me.xuxiaoxiao.chatapi.qq.QQTools;
import me.xuxiaoxiao.chatapi.qq.entity.message.QQMessage;

public class QQDemo {
    public static final QQClient QQ_CLIENT = new QQClient(new QQClient.QQChatListener(){

        @Override
        public void onQRCode(File qrCode) {
            System.out.println(String.format("\u83b7\u53d6\u5230\u767b\u5f55\u4e8c\u7ef4\u7801\uff1a%s", qrCode.getAbsolutePath()));
        }

        @Override
        public void onAvatar(String base64Avatar) {
            System.out.println(String.format("\u83b7\u53d6\u5230\u7528\u6237\u5934\u50cf\uff1a%s", base64Avatar));
        }

        @Override
        public void onException(String reason) {
            System.out.println(String.format("\u7a0b\u5e8f\u5f02\u5e38\uff1a%s", reason));
        }

        @Override
        public void onLogin() {
            System.out.println("\u767b\u5f55\u6210\u529f");
        }

        @Override
        public void onMessage(QQMessage qqMessage) {
            System.out.println(QQTools.GSON.toJson((Object)qqMessage));
            if (qqMessage.fromGroup != null && qqMessage.fromGroupMember.id != QQDemo.QQ_CLIENT.userMe().id) {
                QQ_CLIENT.sendText(qqMessage.fromGroup, qqMessage.content);
            }
            if (qqMessage.fromDiscuss != null && qqMessage.fromDiscussMember.id != QQDemo.QQ_CLIENT.userMe().id) {
                QQ_CLIENT.sendText(qqMessage.fromDiscuss, qqMessage.content);
            }
            if (qqMessage.fromUser != null && qqMessage.fromUser.id != QQDemo.QQ_CLIENT.userMe().id) {
                QQ_CLIENT.sendText(qqMessage.fromUser, qqMessage.content);
            }
        }

        @Override
        public void onLogout() {
            System.out.println("\u9000\u51fa\u767b\u5f55");
        }
    });

    public static void main(String[] args) {
        QQ_CLIENT.startup();
        Scanner scanner = new Scanner(System.in);
        block12: while (true) {
            System.out.println("\u8bf7\u8f93\u5165\u6307\u4ee4");
            switch (scanner.nextLine()) {
                case "sendFriend": {
                    System.out.println("friendId:");
                    long friendId = Long.parseLong(scanner.nextLine());
                    System.out.println("content:");
                    String content = scanner.nextLine();
                    QQ_CLIENT.sendText(QQ_CLIENT.userFriend(friendId), content);
                    continue block12;
                }
                case "sendGroup": {
                    System.out.println("groupId:");
                    long groupId = Long.parseLong(scanner.nextLine());
                    System.out.println("content:");
                    String content = scanner.nextLine();
                    QQ_CLIENT.sendText(QQ_CLIENT.userGroup(groupId), content);
                    continue block12;
                }
                case "sendDiscuss": {
                    System.out.println("discussId:");
                    long discussId = Long.parseLong(scanner.nextLine());
                    System.out.println("content:");
                    String content = scanner.nextLine();
                    QQ_CLIENT.sendText(QQ_CLIENT.userDiscuss(discussId), content);
                    continue block12;
                }
                case "quit": {
                    System.out.println("logging out");
                    QQ_CLIENT.shutdown();
                    return;
                }
            }
            System.out.println("\u672a\u77e5\u6307\u4ee4");
        }
    }
}

