/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.chatapi.qq;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.logging.Logger;
import me.xuxiaoxiao.chatapi.qq.protocol.ResultPoll;

final class QQTools {
    static final Logger LOGGER = Logger.getLogger("me.xuxiaoxiao.chatapi.qq");
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResultPoll.Item.Content.class, (Object)new ResultPoll.ContentParser()).create();

    QQTools() {
    }

    static String hash(String qqStr, String ptWebqq) {
        int[] ptWebqqHash = new int[4];
        for (int i = 0; i < ptWebqq.length(); ++i) {
            int n = i % 4;
            ptWebqqHash[n] = ptWebqqHash[n] ^ ptWebqq.charAt(i);
        }
        int[] qqStrHash = new int[4];
        long lb = Long.parseLong(qqStr);
        qqStrHash[0] = (int)(lb >> 24 & 0xFFL ^ 0x45L);
        qqStrHash[1] = (int)(lb >> 16 & 0xFFL ^ 0x43L);
        qqStrHash[2] = (int)(lb >> 8 & 0xFFL ^ 0x4FL);
        qqStrHash[3] = (int)(lb & 0xFFL ^ 0x4BL);
        int[] hash = new int[8];
        for (int i = 0; i < hash.length; ++i) {
            hash[i] = i % 2 == 0 ? ptWebqqHash[i >> 1] : qqStrHash[i >> 1];
        }
        String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuilder str = new StringBuilder();
        for (int integer : hash) {
            str.append(hex[integer >> 4 & 0xF]);
            str.append(hex[integer & 0xF]);
        }
        return str.toString();
    }

    static int hashQRSig(String qrsig) {
        int e = 0;
        int n = qrsig.length();
        for (int i = 0; n > i; ++i) {
            e += (e << 5) + qrsig.charAt(i);
        }
        return Integer.MAX_VALUE & e;
    }
}

