/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.rwexcel.reader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import me.xuxiaoxiao.rwexcel.ExcelCell;
import me.xuxiaoxiao.rwexcel.ExcelRow;
import me.xuxiaoxiao.rwexcel.ExcelSheet;
import me.xuxiaoxiao.rwexcel.reader.ExcelReader;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class ExcelStreamReader
implements ExcelReader {
    /*
     * Unable to fully structure code
     */
    @Override
    public void read(@Nonnull InputStream inStream, @Nonnull ExcelReader.Listener listener) throws Exception {
        inStream = FileMagic.prepareToCheckMagic((InputStream)inStream);
        magic = FileMagic.valueOf((InputStream)inStream);
        switch (1.$SwitchMap$org$apache$poi$poifs$filesystem$FileMagic[magic.ordinal()]) {
            case 1: {
                pStream = new POIFSFileSystem(inStream);
                var5_6 = null;
                xlsScanner = new XlsScanner(listener);
                xlsScanner.setFormatListener(new FormatTrackingHSSFListener((HSSFListener)new MissingRecordAwareHSSFListener((HSSFListener)xlsScanner)));
                hssfRequest = new HSSFRequest();
                hssfRequest.addListenerForAllRecords((HSSFListener)xlsScanner.getFormatListener());
                eventFactory = new HSSFEventFactory();
                eventFactory.processWorkbookEvents(hssfRequest, pStream);
                if (pStream == null) break;
                if (var5_6 == null) ** GOTO lbl22
                try {
                    pStream.close();
                }
                catch (Throwable xlsScanner) {
                    var5_6.addSuppressed(xlsScanner);
                }
                break;
lbl22:
                // 1 sources

                pStream.close();
                break;
                catch (Throwable xlsScanner) {
                    try {
                        var5_6 = xlsScanner;
                        throw xlsScanner;
                    }
                    catch (Throwable var9_16) {
                        if (pStream != null) {
                            if (var5_6 != null) {
                                try {
                                    pStream.close();
                                }
                                catch (Throwable var10_20) {
                                    var5_6.addSuppressed(var10_20);
                                }
                            } else {
                                pStream.close();
                            }
                        }
                        throw var9_16;
                    }
                }
            }
            case 2: {
                reader = new XSSFReader(OPCPackage.open((InputStream)inStream));
                iterator = (XSSFReader.SheetIterator)reader.getSheetsData();
                sheetIndex = -1;
                while (iterator.hasNext()) {
                    stream = iterator.next();
                    var8_15 = null;
                    try {
                        sheet = new ExcelSheet(++sheetIndex, iterator.getSheetName());
                        listener.onSheetStart(sheet);
                        sheetParser = SAXHelper.newXMLReader();
                        sheetParser.setContentHandler((ContentHandler)new XSSFSheetXMLHandler((Styles)reader.getStylesTable(), (SharedStrings)reader.getSharedStringsTable(), (XSSFSheetXMLHandler.SheetContentsHandler)new XlsxScanner(sheet, listener), new DataFormatter(), false));
                        sheetParser.parse(new InputSource(stream));
                    }
                    catch (Throwable var9_19) {
                        var8_15 = var9_19;
                        throw var9_19;
                    }
                    finally {
                        if (stream == null) continue;
                        if (var8_15 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable var9_18) {
                                var8_15.addSuppressed(var9_18);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u80fd\u8bc6\u522bExcel\u6587\u4ef6");
            }
        }
        inStream.close();
    }

    public static class XlsxScanner
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private final ExcelSheet sheet;
        private final ExcelReader.Listener listener;
        private int colFirst = -1;
        private int colLast = -1;
        private List<String> valList = new LinkedList<String>();

        public XlsxScanner(ExcelSheet sheet, ExcelReader.Listener listener) {
            this.sheet = sheet;
            this.listener = listener;
        }

        public void startRow(int rowNum) {
        }

        public void endRow(int rowNum) {
            if (this.colFirst >= 0 && this.colLast >= this.colFirst) {
                ExcelRow excelRow = new ExcelRow(this.sheet.getShtIndex(), rowNum);
                excelRow.setColFirst(this.colFirst);
                excelRow.setColLast(this.colLast);
                LinkedList<ExcelCell> cells = new LinkedList<ExcelCell>();
                for (int i = this.colFirst; i <= this.colLast; ++i) {
                    if (this.valList.get(i - this.colFirst) == null) continue;
                    cells.add(new ExcelCell(this.sheet.getShtIndex(), rowNum, i, this.valList.get(i - this.colFirst)));
                }
                this.listener.onRow(this.sheet, excelRow, cells);
            }
            this.colFirst = -1;
            this.colLast = -1;
            this.valList.clear();
        }

        public void cell(String cellReference, String formattedValue, XSSFComment xssfComment) {
            short col = new CellReference(cellReference).getCol();
            if (this.colFirst < 0) {
                this.colFirst = col;
                this.colLast = col;
                this.valList.add(formattedValue);
            } else {
                while (++this.colLast < col) {
                    this.valList.add(null);
                }
                this.valList.add(formattedValue);
            }
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
        }

        public void endSheet() {
            this.listener.onSheetEnd(this.sheet);
        }
    }

    private static class XlsScanner
    implements HSSFListener {
        private ExcelReader.Listener listener;
        private FormatTrackingHSSFListener formatListener;
        private SSTRecord cacheString;
        private ExcelSheet sheet;
        private BoundSheetRecord[] orderedBSRs;
        private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
        private int rowIndex = -1;
        private int colFirst = -1;
        private int colLast = -1;
        private List<String> valList = new LinkedList<String>();
        private int nextStringRecordColumn = -1;
        private boolean handleNextStringRecord = false;

        public XlsScanner(ExcelReader.Listener listener) {
            this.listener = listener;
        }

        public FormatTrackingHSSFListener getFormatListener() {
            return this.formatListener;
        }

        public void setFormatListener(FormatTrackingHSSFListener formatListener) {
            this.formatListener = formatListener;
        }

        public void finishRow() {
            if (this.rowIndex >= 0 && this.colFirst >= 0 && this.colLast >= this.colFirst) {
                int i;
                for (i = 0; i <= this.colLast - this.colFirst && this.valList.get(i) == null; ++i) {
                    this.valList.remove(i--);
                    ++this.colFirst;
                }
                for (i = this.colLast - this.colFirst; i >= 0 && this.valList.get(i) == null; --i) {
                    this.valList.remove(i);
                    --this.colLast;
                }
                if (this.colFirst >= 0 && this.colLast >= this.colFirst) {
                    ExcelRow excelRow = new ExcelRow(this.sheet.getShtIndex(), this.rowIndex);
                    excelRow.setColFirst(this.colFirst);
                    excelRow.setColLast(this.colLast);
                    LinkedList<ExcelCell> cells = new LinkedList<ExcelCell>();
                    for (int i2 = this.colFirst; i2 <= this.colLast; ++i2) {
                        if (this.valList.get(i2 - this.colFirst) == null) continue;
                        cells.add(new ExcelCell(this.sheet.getShtIndex(), this.rowIndex, i2, this.valList.get(i2 - this.colFirst)));
                    }
                    this.listener.onRow(this.sheet, excelRow, cells);
                }
            }
            this.rowIndex = -1;
            this.colFirst = -1;
            this.colLast = -1;
            this.valList.clear();
        }

        public void processRecord(Record record) {
            if (record instanceof CellValueRecordInterface) {
                CellValueRecordInterface cellRecord = (CellValueRecordInterface)record;
                if (cellRecord.getRow() != this.rowIndex) {
                    this.rowIndex = cellRecord.getRow();
                    this.colFirst = cellRecord.getColumn();
                    this.colLast = cellRecord.getColumn();
                } else if (this.colFirst < 0) {
                    this.colFirst = cellRecord.getColumn();
                    this.colLast = cellRecord.getColumn();
                } else {
                    while (++this.colLast < cellRecord.getColumn()) {
                        this.valList.add(null);
                    }
                }
                block0 : switch (record.getSid()) {
                    case 513: {
                        this.valList.add(null);
                        break;
                    }
                    case 517: {
                        BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                        this.valList.add(String.valueOf(!boolErrRecord.isError() && boolErrRecord.getBooleanValue()));
                        break;
                    }
                    case 6: {
                        FormulaRecord formulaRecord = (FormulaRecord)record;
                        switch (formulaRecord.getCachedResultType()) {
                            case 0: {
                                this.valList.add(this.formatListener.formatNumberDateCell((CellValueRecordInterface)formulaRecord));
                                break block0;
                            }
                            case 1: {
                                this.handleNextStringRecord = true;
                                this.nextStringRecordColumn = formulaRecord.getColumn();
                                this.valList.add(null);
                                break block0;
                            }
                            case 3: {
                                this.valList.add("");
                                break block0;
                            }
                            case 4: {
                                this.valList.add(String.valueOf(formulaRecord.getCachedBooleanValue()));
                                break block0;
                            }
                        }
                        this.valList.add(null);
                        break;
                    }
                    case 516: {
                        LabelRecord labelRecord = (LabelRecord)record;
                        this.valList.add(labelRecord.getValue());
                        break;
                    }
                    case 253: {
                        LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                        this.valList.add(this.cacheString.getString(labelSSTRecord.getSSTIndex()).getString());
                        break;
                    }
                    case 515: {
                        NumberRecord numberRecord = (NumberRecord)record;
                        this.valList.add(this.formatListener.formatNumberDateCell((CellValueRecordInterface)numberRecord));
                        break;
                    }
                    case 638: {
                        RKRecord rkRecord = (RKRecord)record;
                        this.valList.add(String.valueOf(rkRecord.getRKNumber()));
                        break;
                    }
                    default: {
                        System.out.println("\u672a\u8bc6\u522b\uff1a" + record.getClass().getSimpleName());
                        break;
                    }
                }
            } else {
                switch (record.getSid()) {
                    case 133: {
                        this.boundSheetRecords.add((BoundSheetRecord)record);
                        break;
                    }
                    case 2057: {
                        BOFRecord bofRecord = (BOFRecord)record;
                        if (bofRecord.getType() != 16) break;
                        if (this.orderedBSRs == null) {
                            this.orderedBSRs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
                        }
                        this.sheet = this.sheet == null ? new ExcelSheet(0, this.orderedBSRs[0].getSheetname()) : new ExcelSheet(this.sheet.getShtIndex() + 1, this.orderedBSRs[this.sheet.getShtIndex() + 1].getSheetname());
                        this.rowIndex = -1;
                        this.colFirst = -1;
                        this.colLast = -1;
                        this.listener.onSheetStart(this.sheet);
                        break;
                    }
                    case 252: {
                        this.cacheString = (SSTRecord)record;
                        break;
                    }
                    case 519: {
                        if (!this.handleNextStringRecord) break;
                        StringRecord stringRecord = (StringRecord)record;
                        this.valList.set(this.nextStringRecordColumn - this.colFirst, stringRecord.getString());
                        this.handleNextStringRecord = false;
                        break;
                    }
                    case 10: {
                        if (this.sheet == null) break;
                        this.listener.onSheetEnd(this.sheet);
                    }
                }
            }
            if (record instanceof LastCellOfRowDummyRecord) {
                this.finishRow();
            }
        }
    }
}

