/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.rwexcel.reader;

import java.io.InputStream;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import me.xuxiaoxiao.rwexcel.ExcelCell;
import me.xuxiaoxiao.rwexcel.ExcelRow;
import me.xuxiaoxiao.rwexcel.ExcelSheet;
import me.xuxiaoxiao.rwexcel.reader.ExcelReader;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelUserReader
implements ExcelReader {
    @Override
    public void read(@Nonnull InputStream inStream, @Nonnull ExcelReader.Listener listener) throws Exception {
        Workbook workbook = WorkbookFactory.create((InputStream)inStream);
        int count = workbook.getNumberOfSheets();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            ExcelSheet excelSheet = new ExcelSheet(i, sheet.getSheetName());
            listener.onSheetStart(excelSheet);
            DataFormatter formatter = new DataFormatter();
            for (int j = sheet.getFirstRowNum(); j < sheet.getLastRowNum() + 1; ++j) {
                Row row = sheet.getRow(j);
                if (row == null) continue;
                LinkedList<ExcelCell> excelCells = new LinkedList<ExcelCell>();
                for (int k = row.getFirstCellNum(); k < row.getLastCellNum() + 1; ++k) {
                    Cell cell = row.getCell(k);
                    String value = formatter.formatCellValue(cell);
                    if (value == null || value.length() <= 0) continue;
                    excelCells.add(new ExcelCell(i, j, k, value));
                }
                if (excelCells.isEmpty()) continue;
                ExcelRow excelRow = new ExcelRow(i, j);
                excelRow.setColFirst(((ExcelCell)excelCells.get(0)).getColIndex());
                excelRow.setColLast(((ExcelCell)excelCells.get(excelCells.size() - 1)).getColIndex());
                listener.onRow(excelSheet, excelRow, excelCells);
            }
            listener.onSheetEnd(excelSheet);
        }
    }
}

