/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.rwexcel.simple;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.rwexcel.ExcelCell;
import me.xuxiaoxiao.rwexcel.ExcelRow;
import me.xuxiaoxiao.rwexcel.ExcelSheet;
import me.xuxiaoxiao.rwexcel.reader.ExcelReader;
import me.xuxiaoxiao.rwexcel.simple.SimpleSheetListener;

public abstract class SimpleExcelListener
implements ExcelReader.Listener {
    private final ArrayList<SimpleSheetListener<?>> listeners = new ArrayList();
    private ExcelSheet sheet = null;

    @Override
    public final void onSheetStart(@Nonnull ExcelSheet sheet) {
        this.sheet = sheet;
        while (this.sheet.getShtIndex() >= this.listeners.size()) {
            this.listeners.add(this.sheetListener(this.sheet));
        }
        SimpleSheetListener<?> sheetListener = this.listeners.get(this.sheet.getShtIndex());
        if (sheetListener != null) {
            sheetListener.onSheetStart(this.sheet);
        }
    }

    @Override
    public final void onRow(@Nonnull ExcelSheet sheet, @Nonnull ExcelRow row, @Nonnull List<ExcelCell> cells) {
        SimpleSheetListener<?> sheetListener = this.listeners.get(this.sheet.getShtIndex());
        if (sheetListener != null) {
            sheetListener.onRow(sheet, row, cells);
        }
    }

    @Override
    public final void onSheetEnd(@Nonnull ExcelSheet sheet) {
        SimpleSheetListener<?> sheetListener = this.listeners.get(this.sheet.getShtIndex());
        if (sheetListener != null) {
            sheetListener.onSheetEnd(this.sheet);
        }
    }

    @Nullable
    public abstract SimpleSheetListener<?> sheetListener(@Nonnull ExcelSheet var1);
}

