/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.rwexcel.simple;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.rwexcel.ExcelCell;
import me.xuxiaoxiao.rwexcel.ExcelRow;
import me.xuxiaoxiao.rwexcel.ExcelSheet;
import me.xuxiaoxiao.rwexcel.reader.ExcelReader;
import me.xuxiaoxiao.rwexcel.simple.ExcelColumn;
import me.xuxiaoxiao.rwexcel.simple.converter.Converter;

public abstract class SimpleSheetListener<T>
implements ExcelReader.Listener {
    private final List<T> list;
    private final ExcelSheet sheet;
    private final int cache;
    private final Class<T> clazz;
    private final boolean adaptive;
    private int rowStart = 0;
    private int rowEnd = 0;
    protected final TreeMap<Integer, Field> fMapper = new TreeMap();
    protected final TreeMap<Integer, Converter> cMapper = new TreeMap();

    public SimpleSheetListener(ExcelSheet sheet) {
        this(sheet, 100);
    }

    public SimpleSheetListener(ExcelSheet sheet, int cache) {
        this.list = new ArrayList<T>(cache);
        this.sheet = sheet;
        this.cache = cache;
        this.clazz = this.entityClass();
        boolean adaptive = true;
        Class<T> i = this.clazz;
        while (!i.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = i.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ExcelColumn.class)) continue;
                field.setAccessible(true);
                ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
                if (excelColumn.index() >= 0) {
                    adaptive = false;
                    if (this.fMapper.containsKey(excelColumn.index())) {
                        throw new IllegalArgumentException(String.format("ExcelColumn\u5217\u51b2\u7a81\uff0c\u6709\u591a\u4e2a\u5e8f\u53f7\u4e3a %d \u7684\u5217", excelColumn.index()));
                    }
                    this.fMapper.put(excelColumn.index(), field);
                    continue;
                }
                if (adaptive) continue;
                throw new IllegalArgumentException(String.format("ExcelColumn\u7684\u5217 %s \u672a\u8bbe\u7f6e\u5e8f\u53f7", excelColumn.value()));
            }
            i = i.getSuperclass();
        }
        this.adaptive = adaptive;
    }

    @Override
    public final void onSheetStart(@Nonnull ExcelSheet sheet) {
    }

    @Override
    public final void onRow(@Nonnull ExcelSheet sheet, @Nonnull ExcelRow row, @Nonnull List<ExcelCell> cells) {
        if (row.getRowIndex() < this.titleRowCount()) {
            this.titleRow(row.getRowIndex(), row, cells);
            this.rowStart = row.getRowIndex() + 1;
            this.rowEnd = row.getRowIndex() + 1;
        } else {
            while (this.rowEnd < row.getRowIndex()) {
                try {
                    if (!this.rowSkip(this.rowEnd, null, null)) {
                        this.list.add(this.rowEntity(this.rowEnd, null, null));
                        if (this.list.size() >= this.cache) {
                            this.flush();
                        }
                    }
                    ++this.rowEnd;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                if (!this.rowSkip(row.getRowIndex(), row, cells)) {
                    this.list.add(this.rowEntity(row.getRowIndex(), row, cells));
                    if (this.list.size() >= this.cache) {
                        this.flush();
                    }
                }
                ++this.rowEnd;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public final void onSheetEnd(@Nonnull ExcelSheet sheet) {
        this.flush();
    }

    @Nonnull
    protected Class<T> entityClass() {
        if (this.clazz == null) {
            Type paramType;
            Type[] typeArguments;
            Class<?> listenerClass = this.getClass();
            if (listenerClass.getGenericSuperclass() instanceof ParameterizedType && (typeArguments = ((ParameterizedType)listenerClass.getGenericSuperclass()).getActualTypeArguments()) != null && typeArguments.length > 0 && (paramType = typeArguments[0]) instanceof Class) {
                return (Class)paramType;
            }
            throw new IllegalStateException("\u672a\u80fd\u81ea\u52a8\u8bc6\u522bSimpleExcelListener\u7684\u6a21\u677f\u53c2\u6570");
        }
        return this.clazz;
    }

    @Nonnull
    public Converter.MismatchPolicy mismatchPolicy() {
        return Converter.MismatchPolicy.Throw;
    }

    protected int titleRowCount() {
        return 1;
    }

    protected void titleRow(int rowIndex, @Nullable ExcelRow row, @Nullable List<ExcelCell> cells) {
        if (rowIndex == 0 && this.adaptive && row != null && cells != null && !cells.isEmpty()) {
            Class<T> i = this.clazz;
            while (!i.equals(Object.class)) {
                Field[] fields;
                block1: for (Field field : fields = i.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(ExcelColumn.class)) continue;
                    ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
                    for (ExcelCell cell : cells) {
                        if (!excelColumn.value().equals(cell.getStrValue())) continue;
                        if (this.fMapper.containsKey(cell.getColIndex())) {
                            throw new IllegalArgumentException(String.format("ExcelColumn\u81ea\u52a8\u5bfb\u5217\u51b2\u7a81\uff0c\u6709\u591a\u4e2a\u6210\u5458\u57dftitle\u4e3a %s", excelColumn.value()));
                        }
                        this.fMapper.put(cell.getColIndex(), field);
                        continue block1;
                    }
                }
                i = i.getSuperclass();
            }
        }
    }

    private void flush() {
        this.onList(this.rowStart, this.rowEnd, this.list);
        this.rowStart = this.rowEnd;
        this.list.clear();
    }

    protected boolean rowSkip(int rowIndex, @Nullable ExcelRow row, @Nullable List<ExcelCell> cells) throws Exception {
        return rowIndex < this.titleRowCount() || row == null;
    }

    @Nullable
    protected T rowEntity(int rowIndex, @Nullable ExcelRow row, @Nullable List<ExcelCell> cells) throws Exception {
        if (row == null || cells == null || cells.isEmpty()) {
            return null;
        }
        T entity = this.clazz.newInstance();
        for (ExcelCell cell : cells) {
            Field field = this.fMapper.get(cell.getColIndex());
            if (field == null) continue;
            Converter converter = this.cMapper.get(cell.getColIndex());
            if (converter == null) {
                converter = field.getAnnotation(ExcelColumn.class).converter().newInstance();
                this.cMapper.put(cell.getColIndex(), converter);
            }
            try {
                field.setAccessible(true);
                field.set(entity, converter.str2obj(field, cell.getStrValue()));
            }
            catch (Exception e) {
                if (this.mismatchPolicy() != Converter.MismatchPolicy.Throw) continue;
                throw e;
            }
        }
        return entity;
    }

    protected abstract void onList(int var1, int var2, @Nonnull List<T> var3);

    public ExcelSheet getSheet() {
        return this.sheet;
    }

    public int getCache() {
        return this.cache;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public boolean isAdaptive() {
        return this.adaptive;
    }
}

