/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.rwexcel.simple;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.rwexcel.ExcelCell;
import me.xuxiaoxiao.rwexcel.ExcelRow;
import me.xuxiaoxiao.rwexcel.ExcelSheet;
import me.xuxiaoxiao.rwexcel.simple.ExcelColumn;
import me.xuxiaoxiao.rwexcel.simple.converter.Converter;
import me.xuxiaoxiao.rwexcel.writer.ExcelWriter;

public abstract class SimpleSheetProvider<T>
implements ExcelWriter.Provider {
    private final List<T> list = new LinkedList<T>();
    private final ExcelSheet sheet;
    private final Class<T> clazz;
    protected final int colFirst;
    protected final int colLast;
    protected final Map<Field, Integer> fMapper = new HashMap<Field, Integer>();
    protected final Map<Field, Converter> cMapper = new HashMap<Field, Converter>();

    public SimpleSheetProvider(ExcelSheet sheet) {
        this.sheet = sheet;
        this.clazz = this.entityClass();
        int colF = Integer.MAX_VALUE;
        int colL = Integer.MIN_VALUE;
        boolean adaptive = true;
        LinkedList<Field> fieldList = new LinkedList<Field>();
        Class<T> i = this.clazz;
        while (!i.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = i.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ExcelColumn.class)) continue;
                field.setAccessible(true);
                fieldList.add(field);
                ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
                if (excelColumn.index() >= 0) {
                    adaptive = false;
                    if (excelColumn.index() < colF) {
                        colF = excelColumn.index();
                    }
                    if (colL < excelColumn.index()) {
                        colL = excelColumn.index();
                    }
                    this.fMapper.put(field, excelColumn.index());
                    continue;
                }
                if (adaptive) continue;
                throw new IllegalArgumentException(String.format("ExcelColumn\u7684\u5217 %s \u672a\u8bbe\u7f6e\u5e8f\u53f7", excelColumn.value()));
            }
            i = i.getSuperclass();
        }
        if (adaptive) {
            Collections.sort(fieldList, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    Class<?> c2;
                    Class<?> c1 = o1.getDeclaringClass();
                    if (c1.equals(c2 = o2.getDeclaringClass())) {
                        return 0;
                    }
                    if (c1.isAssignableFrom(c2)) {
                        return -1;
                    }
                    return 1;
                }
            });
            colF = 0;
            colL = fieldList.size() - 1;
            for (int i2 = 0; i2 < fieldList.size(); ++i2) {
                this.fMapper.put((Field)fieldList.get(i2), i2);
            }
        }
        this.colFirst = colF;
        this.colLast = colL;
        if (this.fMapper.isEmpty()) {
            throw new IllegalArgumentException("SimpleSheetProvider\u7684\u6a21\u677f\u53c2\u6570\u4e2d\u672a\u627e\u5230\u4efb\u4f55\u4f7f\u7528@Excelolumn\u6807\u8bb0\u7684\u5c5e\u6027");
        }
    }

    @Override
    @Nonnull
    public ExcelWriter.Version version() {
        return ExcelWriter.Version.XLSX;
    }

    @Override
    @Nullable
    public ExcelSheet provideSheet(int lastSheetIndex) {
        return null;
    }

    @Override
    @Nullable
    public final ExcelRow provideRow(@Nonnull ExcelSheet sheet, int lastRowIndex) {
        List<T> temp;
        if (lastRowIndex + 1 < this.titleRowCount()) {
            return this.titleRow(lastRowIndex);
        }
        if (this.list.isEmpty() && (temp = this.queryList(lastRowIndex)) != null) {
            this.list.addAll(temp);
        }
        while (this.list.size() > 0 && this.entitySkip(lastRowIndex, this.list.get(0))) {
            this.list.remove(0);
        }
        if (this.list.isEmpty()) {
            return null;
        }
        return this.entityRow(lastRowIndex, this.list.get(0));
    }

    @Override
    @Nonnull
    public final List<ExcelCell> provideCells(@Nonnull ExcelSheet sheet, @Nonnull ExcelRow row) {
        if (row.getRowIndex() < this.titleRowCount()) {
            return this.titleCells(row);
        }
        try {
            return this.entityCells(row, this.list.remove(0));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    protected Class<T> entityClass() {
        if (this.clazz == null) {
            Type paramType;
            Type[] typeArguments;
            Class<?> providerClass = this.getClass();
            if (providerClass.getGenericSuperclass() instanceof ParameterizedType && (typeArguments = ((ParameterizedType)providerClass.getGenericSuperclass()).getActualTypeArguments()) != null && typeArguments.length > 0 && (paramType = typeArguments[0]) instanceof Class) {
                return (Class)paramType;
            }
            throw new IllegalStateException("\u672a\u80fd\u81ea\u52a8\u8bc6\u522bSimpleSheetProvider\u7684\u6a21\u677f\u53c2\u6570");
        }
        return this.clazz;
    }

    @Nonnull
    public Converter.MismatchPolicy mismatchPolicy() {
        return Converter.MismatchPolicy.Throw;
    }

    protected int titleRowCount() {
        return 1;
    }

    @Nullable
    protected ExcelRow titleRow(int lastRowIndex) {
        ExcelRow excelRow = new ExcelRow(this.sheet.getShtIndex(), lastRowIndex + 1);
        excelRow.setColFirst(this.colFirst);
        excelRow.setColLast(this.colLast);
        return excelRow;
    }

    @Nonnull
    protected List<ExcelCell> titleCells(@Nonnull ExcelRow row) {
        LinkedList<ExcelCell> cells = new LinkedList<ExcelCell>();
        for (Map.Entry<Field, Integer> entry : this.fMapper.entrySet()) {
            cells.add(new ExcelCell(this.sheet.getShtIndex(), row.getRowIndex(), entry.getValue(), entry.getKey().getAnnotation(ExcelColumn.class).value()));
        }
        Collections.sort(cells, new Comparator<ExcelCell>(){

            @Override
            public int compare(ExcelCell o1, ExcelCell o2) {
                return o1.getColIndex() - o2.getColIndex();
            }
        });
        return cells;
    }

    protected boolean entitySkip(int lastRowIndex, @Nullable T entity) {
        return entity == null;
    }

    @Nullable
    protected ExcelRow entityRow(int lastRowIndex, @Nullable T entity) {
        ExcelRow excelRow = new ExcelRow(this.sheet.getShtIndex(), lastRowIndex + 1);
        excelRow.setColFirst(this.colFirst);
        excelRow.setColLast(this.colLast);
        return excelRow;
    }

    @Nonnull
    protected List<ExcelCell> entityCells(@Nonnull ExcelRow row, @Nullable T entity) throws Exception {
        if (entity == null) {
            return new LinkedList<ExcelCell>();
        }
        LinkedList<ExcelCell> cells = new LinkedList<ExcelCell>();
        for (Map.Entry<Field, Integer> entry : this.fMapper.entrySet()) {
            Field field = entry.getKey();
            Converter converter = this.cMapper.get(field);
            if (converter == null) {
                converter = field.getAnnotation(ExcelColumn.class).converter().newInstance();
                this.cMapper.put(field, converter);
            }
            try {
                cells.add(new ExcelCell(this.sheet.getShtIndex(), row.getRowIndex(), this.fMapper.get(field), converter.obj2str(field, field.get(entity))));
            }
            catch (Exception e) {
                if (this.mismatchPolicy() != Converter.MismatchPolicy.Throw) continue;
                throw e;
            }
        }
        Collections.sort(cells, new Comparator<ExcelCell>(){

            @Override
            public int compare(ExcelCell o1, ExcelCell o2) {
                return o1.getColIndex() - o2.getColIndex();
            }
        });
        return cells;
    }

    public abstract List<T> queryList(int var1);

    public ExcelSheet getSheet() {
        return this.sheet;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }
}

