/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.rwexcel.simple.converter;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Converter {
    public static final String D_Y = "yyyy";
    public static final String D_YM = "yyyy-MM";
    public static final String D_YMD = "yyyy-MM-dd";
    public static final String D_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String D_YMDHMSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final Pattern P_Y = Pattern.compile("[1-9]\\d{3}");
    public static final Pattern P_YM = Pattern.compile("[1-9]\\d{3}-\\d{1,2}");
    public static final Pattern P_YMD = Pattern.compile("[1-9]\\d{3}-\\d{1,2}-\\d{1,2}");
    public static final Pattern P_YMDHMS = Pattern.compile("[1-9]\\d{3}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}");
    public static final Pattern P_YMDHMSS = Pattern.compile("[1-9]\\d{3}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{1,3}");
    private final HashMap<String, SimpleDateFormat> dateFormats = new HashMap();

    @Nullable
    public Object str2obj(@Nonnull Field field, @Nonnull String str) {
        Class<?> type = field.getType();
        if (String.class.equals(type)) {
            return str;
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return Integer.parseInt(str);
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return Double.parseDouble(str);
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return Float.valueOf(Float.parseFloat(str));
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return Long.parseLong(str);
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return Boolean.parseBoolean(str);
        }
        if (Date.class.equals(type)) {
            if (P_Y.matcher(str).matches()) {
                return this.dateParse(D_Y, str);
            }
            if (P_YM.matcher(str).matches()) {
                return this.dateParse(D_YM, str);
            }
            if (P_YMD.matcher(str).matches()) {
                return this.dateParse(D_YMD, str);
            }
            if (P_YMDHMS.matcher(str).matches()) {
                return this.dateParse(D_YMDHMS, str);
            }
            if (P_YMDHMSS.matcher(str).matches()) {
                return this.dateParse(D_YMDHMSS, str);
            }
        }
        throw new RuntimeException(String.format("\u672a\u80fd\u5c06\u503c\u3010%s\u3011\u89e3\u6790\u6210\u3010%s\u3011\u7c7b\u578b\u7684\u503c ", str, type.getSimpleName()));
    }

    @Nullable
    public String obj2str(@Nonnull Field field, @Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Date) {
            return this.dateFormat(D_YMDHMS, (Date)obj);
        }
        if (obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Boolean) {
            return String.valueOf(obj);
        }
        throw new RuntimeException(String.format("\u672a\u80fd\u5c06\u3010%s\u3011\u7c7b\u578b\u503c\u8f6c\u6362\u6210\u5b57\u7b26\u4e32", obj.getClass().getSimpleName()));
    }

    @Nonnull
    public Date dateParse(@Nonnull String format, @Nonnull String dateStr) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(dateStr);
        SimpleDateFormat dateFormat = this.dateFormats.get(format);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(format);
            this.dateFormats.put(format, dateFormat);
        }
        try {
            return dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("\u65e5\u671f:%s \u4e0d\u7b26\u5408\u683c\u5f0f:%s", dateStr, format));
        }
    }

    @Nonnull
    public String dateFormat(@Nonnull String format, @Nonnull Date date) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(date);
        SimpleDateFormat dateFormat = this.dateFormats.get(format);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(format);
            this.dateFormats.put(format, dateFormat);
        }
        return dateFormat.format(date);
    }

    public static enum MismatchPolicy {
        Throw,
        Default;

    }
}

