/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.rwexcel.writer;

import java.io.OutputStream;
import javax.annotation.Nonnull;
import me.xuxiaoxiao.rwexcel.ExcelCell;
import me.xuxiaoxiao.rwexcel.ExcelRow;
import me.xuxiaoxiao.rwexcel.ExcelSheet;
import me.xuxiaoxiao.rwexcel.writer.ExcelWriter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUserWriter
implements ExcelWriter {
    @Override
    public void write(@Nonnull OutputStream outStream, @Nonnull ExcelWriter.Provider provider) throws Exception {
        ExcelSheet excelSheet;
        HSSFWorkbook workbook = provider.version() == ExcelWriter.Version.XLS ? new HSSFWorkbook() : new XSSFWorkbook();
        int i = 0;
        while ((excelSheet = provider.provideSheet(i - 1)) != null) {
            ExcelRow excelRow;
            if (excelSheet.getShtIndex() != i) {
                throw new IllegalArgumentException(String.format("\u5199\u51fasheet\u9519\u8bef\uff0c\u671f\u671bshtIndex\uff1a%d\uff0c\u5b9e\u9645shtIndex\uff1a%d", i, excelSheet.getShtIndex()));
            }
            if (excelSheet.getShtName().trim().isEmpty()) {
                throw new IllegalArgumentException("\u5199\u51fasheet\u9519\u8bef\uff0cshtName\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Sheet sheet = workbook.createSheet(excelSheet.getShtName());
            workbook.setSheetOrder(excelSheet.getShtName(), excelSheet.getShtIndex());
            int lastRowIndex = -1;
            int j = 0;
            while ((excelRow = provider.provideRow(excelSheet, lastRowIndex)) != null) {
                if (excelRow.getShtIndex() != i) {
                    throw new IllegalArgumentException(String.format("\u5199\u51farow\u9519\u8bef\uff0c\u671f\u671bshtIndex\uff1a%d\uff0c\u5b9e\u9645shtIndex\uff1a%d", i, excelRow.getShtIndex()));
                }
                if (excelRow.getRowIndex() < j) {
                    throw new IllegalArgumentException(String.format("\u5199\u51farow\u9519\u8bef\uff0c\u671f\u671browIndex\uff1a\u81f3\u5c11\u4e3a%d\uff0c\u5b9e\u9645shtIndex\uff1a%d", j, excelRow.getShtIndex()));
                }
                while (j < excelRow.getRowIndex()) {
                    sheet.createRow(j++);
                }
                lastRowIndex = j;
                Row row = sheet.createRow(excelRow.getRowIndex());
                int lastColIndex = -1;
                for (ExcelCell excelCell : provider.provideCells(excelSheet, excelRow)) {
                    if (excelCell == null) continue;
                    if (excelCell.getShtIndex() != i) {
                        throw new IllegalArgumentException(String.format("\u5199\u51facell\u9519\u8bef\uff0c\u671f\u671bshtIndex\uff1a%d\uff0c\u5b9e\u9645shtIndex\uff1a%d", i, excelCell.getShtIndex()));
                    }
                    if (excelCell.getRowIndex() != j) {
                        throw new IllegalArgumentException(String.format("\u5199\u51facell\u9519\u8bef\uff0c\u671f\u671browIndex\uff1a%d\uff0c\u5b9e\u9645rowIndex\uff1a%d", j, excelCell.getRowIndex()));
                    }
                    if (excelCell.getColIndex() < 0 || excelCell.getColIndex() <= lastColIndex) {
                        throw new IllegalArgumentException(String.format("\u5199\u51facell\u9519\u8bef\uff0c\u671f\u671bcolIndex\u5927\u4e8e0\u4e14\u6309\u987a\u5e8f\uff0c\u5b9e\u9645colIndex\uff1a%d", excelCell.getColIndex()));
                    }
                    lastColIndex = excelCell.getColIndex();
                    Cell cell = row.createCell(excelCell.getColIndex(), CellType.STRING);
                    cell.setCellValue(excelCell.getStrValue());
                }
                ++j;
            }
            ++i;
        }
        workbook.write(outStream);
        workbook.close();
        outStream.close();
    }
}

