/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.xtools.common.code.XCodeTools;
import me.xuxiaoxiao.xtools.common.config.XConfigTools;
import me.xuxiaoxiao.xtools.common.config.configs.XConfigs;
import me.xuxiaoxiao.xtools.common.http.XHttpTools;
import me.xuxiaoxiao.xtools.common.http.executor.XHttpExecutor;
import me.xuxiaoxiao.xtools.common.log.XLogTools;
import me.xuxiaoxiao.xtools.common.time.XTimeTools;

public final class XTools {
    public static final String CFG_PREFIX = "me.xuxiaoxiao$xtools-common$";

    private XTools() {
    }

    @Nullable
    public static String md5(@Nonnull String str) {
        try {
            return XCodeTools.hash("MD5", str.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String md5(@Nonnull File file) {
        try {
            return XCodeTools.hash("MD5", file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static String sha1(@Nonnull String str) {
        try {
            return XCodeTools.hash("SHA-1", str.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String sha1(@Nonnull File file) {
        try {
            return XCodeTools.hash("SHA-1", file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nonnull
    public static XHttpExecutor.Response http(@Nonnull XHttpExecutor.Request request) {
        return XHttpTools.http(XHttpTools.EXECUTOR, request);
    }

    @Nonnull
    public static XHttpExecutor.Response http(@Nonnull XHttpExecutor executor, @Nonnull XHttpExecutor.Request request) {
        return XHttpTools.http(executor, request);
    }

    public static boolean strEmpty(@Nullable String str) {
        return str == null || str.length() == 0;
    }

    public static boolean strBlank(@Nullable String str) {
        return str == null || str.trim().length() == 0;
    }

    @Nullable
    public static String strTrim(@Nullable String str) {
        return str == null ? null : str.trim();
    }

    @Nullable
    public static String[] strTrim(@Nullable String[] strs) {
        if (strs == null) {
            return null;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            strs[i] = strs[i] == null ? null : strs[i].trim();
        }
        return strs;
    }

    @Nonnull
    public static String strJoin(@Nonnull String[] strArr, @Nonnull String glue) {
        StringBuilder sbStr = new StringBuilder();
        for (String str : strArr) {
            if (sbStr.length() > 0) {
                sbStr.append(glue);
            }
            sbStr.append(str);
        }
        return sbStr.toString();
    }

    @Nonnull
    public static String strJoin(@Nonnull Collection<String> strSet, @Nonnull String glue) {
        StringBuilder sbStr = new StringBuilder();
        for (String str : strSet) {
            if (sbStr.length() > 0) {
                sbStr.append(glue);
            }
            sbStr.append(str);
        }
        return sbStr.toString();
    }

    @Nonnull
    public static String strJoin(@Nonnull Map<?, ?> strMap, @Nonnull String glueInner, @Nonnull String glueOuter) {
        StringBuilder sbStr = new StringBuilder();
        for (Object key : strMap.keySet()) {
            if (sbStr.length() > 0) {
                sbStr.append(glueOuter);
            }
            sbStr.append(key).append(glueInner).append(strMap.get(key));
        }
        return sbStr.toString();
    }

    @Nonnull
    public static File strToFile(@Nullable String str, @Nonnull String path, @Nonnull String charset) throws IOException {
        File file = new File(path);
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(file));){
            outStream.write(str == null ? new byte[]{} : str.getBytes(charset));
            outStream.flush();
        }
        return file;
    }

    @Nonnull
    public static String fileToStr(@Nonnull File file, @Nonnull String charset) throws IOException {
        try (FileInputStream fInStream = new FileInputStream(file);){
            String string = XTools.streamToStr(fInStream, charset);
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public static File fileToFile(@Nonnull File file, @Nonnull String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public static String streamToStr(@Nonnull InputStream inStream, @Nonnull String charset) throws IOException {
        int count;
        char[] buffer = new char[1024];
        StringBuilder sbStr = new StringBuilder();
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, charset));
        while ((count = bufReader.read(buffer)) > 0) {
            sbStr.append(buffer, 0, count);
        }
        return sbStr.toString();
    }

    @Nonnull
    public static File streamToFile(@Nonnull InputStream inStream, @Nonnull String path) throws IOException {
        byte[] buffer = new byte[1024];
        File file = new File(path);
        BufferedInputStream bufInStream = new BufferedInputStream(inStream);
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(file));){
            int count;
            while ((count = bufInStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, count);
            }
            outStream.flush();
        }
        return file;
    }

    public static void streamToStream(@Nonnull InputStream inStream, @Nonnull OutputStream outStream) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        BufferedInputStream bufInStream = new BufferedInputStream(inStream);
        BufferedOutputStream bufOutStream = new BufferedOutputStream(outStream);
        while ((count = bufInStream.read(buffer)) > 0) {
            bufOutStream.write(buffer, 0, count);
        }
        bufOutStream.flush();
    }

    public static int dateType(@Nonnull Date date) {
        return XTimeTools.dateType(date);
    }

    @Nonnull
    public static String dateFormat(@Nonnull Date date) {
        return XTimeTools.dateFormat("yyyy-MM-dd HH:mm:ss", date);
    }

    @Nonnull
    public static String dateFormat(@Nonnull String format, @Nonnull Date date) {
        return XTimeTools.dateFormat(format, date);
    }

    @Nonnull
    public static Date dateParse(@Nonnull String dateStr) {
        return XTimeTools.dateParse("yyyy-MM-dd HH:mm:ss", dateStr);
    }

    @Nonnull
    public static Date dateParse(@Nonnull String format, @Nonnull String dateStr) {
        return XTimeTools.dateParse(format, dateStr);
    }

    @Nonnull
    public static Date date(@Nullable Date base, int offset) {
        return XTimeTools.date(base, offset);
    }

    @Nonnull
    public static Date dateByWeek(@Nullable Date base, int weekOffset, int dayIndex) {
        return XTimeTools.dateByWeek(base, weekOffset, dayIndex);
    }

    @Nonnull
    public static Date dateByMonth(@Nullable Date base, int monthOffset, int dayIndex) {
        return XTimeTools.dateByMonth(base, monthOffset, dayIndex);
    }

    @Nonnull
    public static Date dateBySeason(@Nullable Date base, int seasonOffset, int dayIndex) {
        return XTimeTools.dateBySeason(base, seasonOffset, dayIndex);
    }

    @Nonnull
    public static Date dateByYear(@Nullable Date base, int yearOffset, int dayIndex) {
        return XTimeTools.dateByYear(base, yearOffset, dayIndex);
    }

    @Nonnull
    public static Date weekByMonth(@Nullable Date base, int monthOffset, int weekIndex) {
        return XTimeTools.weekByMonth(base, monthOffset, weekIndex);
    }

    @Nonnull
    public static Date weekBySeason(@Nullable Date base, int seasonOffset, int weekIndex) {
        return XTimeTools.weekBySeason(base, seasonOffset, weekIndex);
    }

    @Nonnull
    public static Date weekByYear(@Nullable Date base, int yearOffset, int weekIndex) {
        return XTimeTools.weekByYear(base, yearOffset, weekIndex);
    }

    @Nonnull
    public static Date monthBySeason(@Nullable Date base, int seasonOffset, int monthIndex) {
        return XTimeTools.monthBySeason(base, seasonOffset, monthIndex);
    }

    @Nonnull
    public static Date monthByYear(@Nullable Date base, int yearOffset, int monthIndex) {
        return XTimeTools.monthByYear(base, yearOffset, monthIndex);
    }

    @Nonnull
    public static Date seasonByYear(@Nullable Date base, int yearOffset, int seasonIndex) {
        return XTimeTools.seasonByYear(base, yearOffset, seasonIndex);
    }

    public static int dateInWeek(@Nullable Date base) {
        return XTimeTools.dateInWeek(base);
    }

    public static int dateInMonth(@Nullable Date base) {
        return XTimeTools.dateInMonth(base);
    }

    public static int dateInSeason(@Nullable Date base) {
        return XTimeTools.dateInSeason(base);
    }

    public static int dateInYear(@Nullable Date base) {
        return XTimeTools.dateInYear(base);
    }

    public static int weekInMonth(@Nullable Date base) {
        return XTimeTools.weekInMonth(base);
    }

    public static int weekInSeason(@Nullable Date base) {
        return XTimeTools.weekInSeason(base);
    }

    public static int weekInYear(@Nullable Date base) {
        return XTimeTools.weekInYear(base);
    }

    public static int monthInSeason(@Nullable Date base) {
        return XTimeTools.monthInSeason(base);
    }

    public static int monthInYear(@Nullable Date base) {
        return XTimeTools.monthInYear(base);
    }

    public static int seasonInYear(@Nullable Date base) {
        return XTimeTools.seasonInYear(base);
    }

    @Nonnull
    public static String solarToLunar(@Nonnull Date solarDate) {
        return XTimeTools.solarToLunar(solarDate);
    }

    @Nonnull
    public static Date lunarToSolar(@Nonnull String lunarDate) {
        return XTimeTools.lunarToSolar(lunarDate);
    }

    public static boolean sysWindows() {
        return System.getProperties().getProperty("os.name").toLowerCase().contains("windows");
    }

    public static boolean sysMacOS() {
        String osName = System.getProperties().getProperty("os.name").toLowerCase();
        return osName.contains("mac") && !osName.contains("x");
    }

    public static boolean sysMacOSX() {
        String osName = System.getProperties().getProperty("os.name").toLowerCase();
        return osName.contains("mac") && osName.contains("x");
    }

    public static boolean sysLinux() {
        String osName = System.getProperties().getProperty("os.name").toLowerCase();
        return osName.contains("linux");
    }

    public static void cfgSet(@Nonnull String key, @Nonnull String val) {
        XConfigTools.X_CONFIGS.cfgSet(key, val);
    }

    @Nullable
    public static String cfgGet(@Nonnull String key) {
        return XConfigTools.X_CONFIGS.cfgGet(key);
    }

    @Nonnull
    public static String cfgDef(@Nonnull String key, @Nonnull String def) {
        return XConfigTools.X_CONFIGS.cfgDef(key, def);
    }

    public static void cfgWatch(@Nonnull String prefix, @Nonnull XConfigs.Watcher watcher) {
        XConfigTools.X_CONFIGS.watcherAdd(prefix, watcher);
    }

    public static void logE(@Nonnull String tag, @Nonnull String error) {
        XLogTools.LOGGER.logE(tag, error);
    }

    public static void logE(@Nonnull String tag, @Nullable Throwable throwable, @Nonnull String error) {
        XLogTools.LOGGER.logE(tag, throwable, error);
    }

    public static void logW(@Nonnull String tag, @Nonnull String warning) {
        XLogTools.LOGGER.logW(tag, warning);
    }

    public static void logW(@Nonnull String tag, @Nullable Throwable throwable, @Nonnull String warning) {
        XLogTools.LOGGER.logW(tag, throwable, warning);
    }

    public static void logN(@Nonnull String tag, @Nonnull String notice) {
        XLogTools.LOGGER.logN(tag, notice);
    }

    public static void logD(@Nonnull String tag, @Nonnull String detail) {
        XLogTools.LOGGER.logD(tag, detail);
    }
}

