/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.config.configs.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.xtools.common.config.configs.XConfigs;

public class XConfigsImpl
extends Observable
implements XConfigs {
    private final Properties configs = new Properties();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    @Nonnull
    public String cfgGet(@Nonnull String key) {
        this.lock.readLock().lock();
        try {
            String string = this.configs.getProperty(key);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cfgSet(@Nonnull String key, @Nonnull String val) {
        this.lock.writeLock().lock();
        try {
            Object valOld = this.configs.setProperty(key, val);
            if (!val.equals(valOld)) {
                this.setChanged();
                this.notifyObservers(new String[]{key, valOld == null ? null : String.valueOf(valOld), val});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String cfgRmv(@Nonnull String key) {
        Objects.requireNonNull(key, "\u914d\u7f6e\u952e\u4e0d\u80fd\u4e3anull");
        this.lock.writeLock().lock();
        try {
            Object value = this.configs.remove(key);
            if (value != null) {
                this.setChanged();
                this.notifyObservers(new String[]{key, String.valueOf(value), null});
                String string = String.valueOf(value);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String cfgDef(@Nonnull String key, @Nonnull String def) {
        this.lock.writeLock().lock();
        try {
            if (this.configs.getProperty(key) == null) {
                this.configs.setProperty(key, def);
                this.setChanged();
                this.notifyObservers(new String[]{key, null, def});
                String string = def;
                return string;
            }
            String string = this.configs.getProperty(key, def);
            return string;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cfgLoad(@Nonnull String file, @Nonnull String charset) throws IOException {
        this.lock.writeLock().lock();
        try {
            Enumeration<URL> urls = XConfigsImpl.class.getClassLoader().getResources(file);
            while (urls != null && urls.hasMoreElements()) {
                Properties properties = new Properties();
                properties.load(new InputStreamReader(urls.nextElement().openStream(), charset));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    this.cfgSet(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
            }
            File config = new File(file);
            if (config.exists() && !config.isDirectory() && config.canRead()) {
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(config), charset));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    this.cfgSet(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cfgIterate(@Nonnull XConfigs.Iteration iteration) {
        this.lock.writeLock().lock();
        try {
            Iterator<Map.Entry<Object, Object>> iterator = this.configs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                if (!iteration.iterate(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()))) continue;
                iterator.remove();
                this.setChanged();
                this.notifyObservers(new String[]{String.valueOf(entry.getKey()), String.valueOf(entry.getValue()), null});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void cfgClear() {
        this.cfgIterate(new XConfigs.Iteration(){

            @Override
            public boolean iterate(@Nonnull String key, @Nonnull String value) {
                return true;
            }
        });
    }

    @Override
    public void watcherAdd(@Nonnull String prefix, @Nonnull XConfigs.Watcher watcher) {
        this.addObserver(new WObserver(prefix, watcher));
    }

    @Override
    public void watcherDel(@Nonnull String prefix, @Nonnull XConfigs.Watcher watcher) {
        this.deleteObserver(new WObserver(prefix, watcher));
    }

    @Override
    public void watcherClear() {
        this.deleteObservers();
    }

    private static class WObserver
    implements Observer {
        public static final int IDX_KEY = 0;
        public static final int IDX_VAL_OLD = 1;
        public static final int IDX_VAL_NEW = 2;
        private final String prefix;
        private final XConfigs.Watcher watcher;

        public WObserver(@Nonnull String prefix, @Nonnull XConfigs.Watcher watcher) {
            this.prefix = prefix.replace("\\.+$", "");
            this.watcher = watcher;
        }

        @Override
        public void update(Observable o, Object arg) {
            String[] update = (String[])arg;
            if (update[0].equals(this.prefix) || update[0].startsWith(this.prefix + ".")) {
                if (update[1] == null && update[2] != null) {
                    this.watcher.onCfgAdd((XConfigs)((Object)o), update[0], update[2]);
                } else if (update[1] != null && update[2] == null) {
                    this.watcher.onCfgDel((XConfigs)((Object)o), update[0], update[1]);
                } else {
                    this.watcher.onCfgChange((XConfigs)((Object)o), update[0], update[1], update[2]);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WObserver wObserver = (WObserver)o;
            return Objects.equals(this.prefix, wObserver.prefix) && Objects.equals(this.watcher, wObserver.watcher);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.watcher);
        }
    }
}

