/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.http;

import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.config.XConfigTools;
import me.xuxiaoxiao.xtools.common.http.executor.XHttpExecutor;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XHttpExecutorImpl;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XResponse;

public final class XHttpTools {
    public static final String CFG_EXECUTOR = "me.xuxiaoxiao$xtools-common$http.executor";
    public static final String CFG_EXECUTOR_DEFAULT = XHttpExecutorImpl.class.getName();
    public static XHttpExecutor EXECUTOR = (XHttpExecutor)XConfigTools.supply(XTools.cfgDef("me.xuxiaoxiao$xtools-common$http.executor", CFG_EXECUTOR_DEFAULT).trim());

    private XHttpTools() {
    }

    @Nonnull
    public static XHttpExecutor.Response http(@Nonnull XHttpExecutor executor, @Nonnull XHttpExecutor.Request request) {
        try {
            return executor.execute(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new XResponse(null, null);
        }
    }

    public static synchronized void addDecorator(@Nonnull Decorator decorator) {
        decorator.setOrigin(EXECUTOR);
        EXECUTOR = decorator;
    }

    public static abstract class Decorator
    implements XHttpExecutor {
        private XHttpExecutor origin;

        final void setOrigin(@Nonnull XHttpExecutor origin) {
            this.origin = origin;
        }

        @Nonnull
        public final XHttpExecutor getOrigin() {
            return this.origin;
        }

        @Override
        public int getConnectTimeout() {
            return this.origin.getConnectTimeout();
        }

        @Override
        public void setConnectTimeout(int timeout) {
            this.origin.setConnectTimeout(timeout);
        }

        @Override
        public int getReadTimeout() {
            return this.origin.getReadTimeout();
        }

        @Override
        public void setReadTimeout(int timeout) {
            this.origin.setReadTimeout(timeout);
        }

        @Override
        public void addCookie(@Nullable URI uri, @Nonnull HttpCookie cookie) {
            this.origin.addCookie(uri, cookie);
        }

        @Override
        @Nonnull
        public List<HttpCookie> getCookies(@Nonnull URI uri) {
            return this.origin.getCookies(uri);
        }

        @Override
        @Nonnull
        public List<HttpCookie> getCookies() {
            return this.origin.getCookies();
        }

        @Override
        public void rmvCookies(@Nullable URI uri, @Nonnull HttpCookie cookie) {
            this.origin.rmvCookies(uri, cookie);
        }

        @Override
        public void rmvCookies() {
            this.origin.rmvCookies();
        }

        @Override
        @Nonnull
        public abstract XHttpExecutor.Response execute(@Nonnull XHttpExecutor.Request var1) throws Exception;
    }
}

