/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.http.executor.impl;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.config.XConfigTools;
import me.xuxiaoxiao.xtools.common.http.executor.XHttpExecutor;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XResponse;

public class XHttpExecutorImpl
implements XHttpExecutor {
    public static final String CFG_CONNECT_TIMEOUT = "me.xuxiaoxiao$xtools-common$http.connectTimeout";
    public static final String CFG_CONNECT_TIMEOUT_DEFAULT = "20000";
    public static final String CFG_READ_TIMEOUT = "me.xuxiaoxiao$xtools-common$http.readTimeout";
    public static final String CFG_READ_TIMEOUT_DEFAULT = "60000";
    public static final String CFG_FOLLOW_REDIRECT = "me.xuxiaoxiao$xtools-common$http.followRedirect";
    public static final String CFG_FOLLOW_REDIRECT_DEFAULT = "false";
    public static final String CFG_CHUNK_LENGTH = "me.xuxiaoxiao$xtools-common$http.chunkLength";
    public static final String CFG_CHUNK_LENGTH_DEFAULT = "262144";
    public static final String CFG_COOKIE_MANAGER = "me.xuxiaoxiao$xtools-common$http.cookieManager";
    public static final String CFG_COOKIE_MANAGER_DEFAULT = XCookieManager.class.getName();
    public static final String CFG_HOSTNAME_VERIFIER = "me.xuxiaoxiao$xtools-common$http.hostnameVerifier";
    public static final String CFG_HOSTNAME_VERIFIER_DEFAULT = XHostnameVerifier.class.getName();
    public static final String CFG_SSL_ALGORITHM = "me.xuxiaoxiao$xtools-common$http.ssl.algorithm";
    public static final String CFG_SSL_ALGORITHM_DEFAULT = "TLS";
    public static final String CFG_SSL_KEY_MANAGERS = "me.xuxiaoxiao$xtools-common$http.ssl.keyManagers";
    public static final String CFG_SSL_KEY_MANAGERS_DEFAULT = "";
    public static final String CFG_SSL_TRUST_MANAGERS = "me.xuxiaoxiao$xtools-common$http.ssl.trustManagers";
    public static final String CFG_SSL_TRUST_MANAGERS_DEFAULT = "";
    public static final String CFG_SSL_SECURE_RANDOM = "me.xuxiaoxiao$xtools-common$http.ssl.secureRandom";
    public static final String CFG_SSL_SECURE_RANDOM_DEFAULT = "";
    private int connectTimeout = Integer.parseInt(XTools.cfgDef("me.xuxiaoxiao$xtools-common$http.connectTimeout", "20000").trim());
    private int readTimeout = Integer.parseInt(XTools.cfgDef("me.xuxiaoxiao$xtools-common$http.readTimeout", "60000").trim());
    private int chunkLength = Integer.parseInt(XTools.cfgDef("me.xuxiaoxiao$xtools-common$http.chunkLength", "262144").trim());
    private boolean followRedirect = Boolean.parseBoolean(XTools.cfgDef("me.xuxiaoxiao$xtools-common$http.followRedirect", "false").trim());
    private CookieManager cookieManager = (CookieManager)XConfigTools.supply(XTools.cfgDef("me.xuxiaoxiao$xtools-common$http.cookieManager", CFG_COOKIE_MANAGER_DEFAULT).trim());
    private HostnameVerifier hostnameVerifier = (HostnameVerifier)XConfigTools.supply(XTools.cfgDef("me.xuxiaoxiao$xtools-common$http.hostnameVerifier", CFG_HOSTNAME_VERIFIER_DEFAULT).trim());
    private SSLContext sslContext;

    public XHttpExecutorImpl() {
        try {
            this.sslContext = SSLContext.getInstance(XTools.cfgDef(CFG_SSL_ALGORITHM, CFG_SSL_ALGORITHM_DEFAULT));
            KeyManager[] keyManagers = null;
            String keyManagersStr = XTools.cfgDef(CFG_SSL_KEY_MANAGERS, "");
            if (!XTools.strBlank(keyManagersStr)) {
                String[] array = keyManagersStr.split(",");
                keyManagers = new KeyManager[array.length];
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    keyManagers[i] = (KeyManager)XConfigTools.supply(array[i].trim());
                }
            }
            TrustManager[] trustManagers = null;
            String trustManagersStr = XTools.cfgDef(CFG_SSL_TRUST_MANAGERS, "");
            if (!XTools.strBlank(trustManagersStr)) {
                String[] array = trustManagersStr.split(",");
                trustManagers = new TrustManager[array.length];
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    trustManagers[i] = (TrustManager)XConfigTools.supply(array[i].trim());
                }
            }
            SecureRandom secureRandom = null;
            String secureRandomStr = XTools.cfgDef(CFG_SSL_SECURE_RANDOM, "").trim();
            if (!XTools.strBlank(secureRandomStr)) {
                secureRandom = (SecureRandom)XConfigTools.supply(secureRandomStr);
            }
            this.sslContext.init(keyManagers, trustManagers, secureRandom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    @Override
    public void addCookie(@Nullable URI uri, @Nonnull HttpCookie cookie) {
        this.cookieManager.getCookieStore().add(uri, cookie);
    }

    @Override
    @Nonnull
    public List<HttpCookie> getCookies(@Nonnull URI uri) {
        return this.cookieManager.getCookieStore().get(uri);
    }

    @Override
    @Nonnull
    public List<HttpCookie> getCookies() {
        return this.cookieManager.getCookieStore().getCookies();
    }

    @Override
    public void rmvCookies(@Nullable URI uri, @Nonnull HttpCookie cookie) {
        this.cookieManager.getCookieStore().remove(uri, cookie);
    }

    @Override
    public void rmvCookies() {
        this.cookieManager.getCookieStore().removeAll();
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public void setChunkLength(int chunkLength) {
        this.chunkLength = chunkLength;
    }

    public boolean getFollowRedirect() {
        return this.followRedirect;
    }

    public void setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
    }

    @Nonnull
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(@Nonnull SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Nonnull
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(@Nonnull HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @Nonnull
    protected HttpURLConnection connect(@Nonnull XHttpExecutor.Request request) throws Exception {
        String url = request.getUrl();
        if (url.toLowerCase().startsWith("http://")) {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(this.getConnectTimeout());
            connection.setReadTimeout(this.getReadTimeout());
            connection.setInstanceFollowRedirects(this.getFollowRedirect());
            return connection;
        }
        if (url.toLowerCase().startsWith("https://")) {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
            connection.setSSLSocketFactory(this.getSSLContext().getSocketFactory());
            connection.setHostnameVerifier(this.getHostnameVerifier());
            connection.setConnectTimeout(this.getConnectTimeout());
            connection.setReadTimeout(this.getReadTimeout());
            connection.setInstanceFollowRedirects(this.getFollowRedirect());
            return connection;
        }
        throw new IllegalArgumentException("XHttpExecutorImpl\u4ec5\u652f\u6301HTTP\u534f\u8bae\u548cHTTPS\u534f\u8bae");
    }

    @Override
    @Nonnull
    public XHttpExecutor.Response execute(@Nonnull XHttpExecutor.Request request) throws Exception {
        HttpURLConnection connection = this.connect(request);
        connection.setRequestMethod(request.getMethod());
        List<XHttpExecutor.KeyValue> headers = request.getHeaders();
        if (headers != null) {
            for (XHttpExecutor.KeyValue keyValue : headers) {
                connection.addRequestProperty(keyValue.key, String.valueOf(keyValue.value));
            }
        }
        if (this.cookieManager != null) {
            Map<String, List<String>> cookiesList = this.cookieManager.get(connection.getURL().toURI(), new HashMap<String, List<String>>());
            for (String cookieType : cookiesList.keySet()) {
                StringBuilder sbCookie = new StringBuilder();
                for (String cookieStr : cookiesList.get(cookieType)) {
                    if (sbCookie.length() > 0) {
                        sbCookie.append(';');
                    }
                    sbCookie.append(cookieStr);
                }
                if (sbCookie.length() <= 0) continue;
                connection.setRequestProperty(cookieType, sbCookie.toString());
            }
        }
        if (request.getContent() != null) {
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            XHttpExecutor.Content content = request.getContent();
            if (content != null) {
                if (content.contentLength() < 0L) {
                    connection.setChunkedStreamingMode(this.getChunkLength());
                }
                try (DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());){
                    content.contentWrite(dataOutputStream);
                }
            }
        }
        InputStream inStream = connection.getInputStream();
        if (this.cookieManager != null) {
            this.cookieManager.put(connection.getURL().toURI(), connection.getHeaderFields());
        }
        return new XResponse(connection, inStream);
    }

    public static class XHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    public static class XCookieManager
    extends CookieManager {
        public XCookieManager() {
            super(null, CookiePolicy.ACCEPT_ALL);
        }
    }
}

