/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.http.executor.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.http.executor.XHttpExecutor;

public final class XRequest
implements XHttpExecutor.Request {
    public static final String CFG_REQ_CHARSET = "me.xuxiaoxiao$xtools-common$http.reqCharset";
    public static final String CFG_REQ_CHARSET_DEFAULT = "utf-8";
    public static final String MIME_URLENCODED = "application/x-www-form-urlencoded";
    public static final String MIME_MULTIPART = "multipart/form-data";
    public static final String MIME_JSON = "application/json";
    public static final String MIME_XML = "text/xml";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    private String charset = XTools.cfgDef("me.xuxiaoxiao$xtools-common$http.reqCharset", "utf-8").trim();
    private String requestMethod;
    private String requestUrl;
    private List<XHttpExecutor.KeyValue> requestQueries;
    private List<XHttpExecutor.KeyValue> requestHeaders;
    private XHttpExecutor.Content requestContent;

    private XRequest(String method, String url) {
        this.setMethod(method);
        this.setUrl(url);
    }

    @Nonnull
    public static XRequest GET(@Nonnull String url) {
        return new XRequest(METHOD_GET, url);
    }

    @Nonnull
    public static XRequest POST(@Nonnull String url) {
        return new XRequest(METHOD_POST, url);
    }

    @Nonnull
    public static XRequest PUT(@Nonnull String url) {
        return new XRequest(METHOD_PUT, url);
    }

    @Nonnull
    public static XRequest DELETE(@Nonnull String url) {
        return new XRequest(METHOD_DELETE, url);
    }

    @Nonnull
    private static String kvJoin(@Nonnull List<XHttpExecutor.KeyValue> keyValues, @Nonnull String charset) throws UnsupportedEncodingException {
        StringBuilder sbStr = new StringBuilder();
        for (XHttpExecutor.KeyValue keyValue : keyValues) {
            if (sbStr.length() > 0) {
                sbStr.append('&');
            }
            sbStr.append(URLEncoder.encode(keyValue.key, charset)).append('=').append(URLEncoder.encode(String.valueOf(keyValue.value), charset));
        }
        return sbStr.toString();
    }

    @Nonnull
    public XRequest query(@Nonnull String key, @Nullable Object value) {
        return this.query(key, value, false);
    }

    @Nonnull
    public XRequest query(@Nonnull String key, @Nullable Object value, boolean append) {
        if (this.requestQueries == null) {
            this.requestQueries = new LinkedList<XHttpExecutor.KeyValue>();
        }
        if (append) {
            Iterator<XHttpExecutor.KeyValue> iterator = this.requestQueries.iterator();
            while (iterator.hasNext()) {
                XHttpExecutor.KeyValue keyValue = iterator.next();
                if (!keyValue.key.equals(key)) continue;
                iterator.remove();
            }
        }
        if (value != null) {
            this.requestQueries.add(new XHttpExecutor.KeyValue(key, value));
        }
        return this;
    }

    @Nonnull
    public XRequest header(@Nonnull String key, @Nullable String value) {
        return this.header(key, value, false);
    }

    @Nonnull
    public XRequest header(@Nonnull String key, @Nullable String value, boolean append) {
        this.setHeader(key, value, append);
        return this;
    }

    @Nonnull
    public XRequest content(@Nonnull String key, @Nullable Object value) {
        return this.content(key, value, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public XRequest content(@Nonnull String key, @Nullable Object value, boolean append) {
        if (this.requestContent == null) {
            this.requestContent = new UrlencodedContent();
        }
        if (this.requestContent instanceof UrlencodedContent) {
            UrlencodedContent urlencodedContent = (UrlencodedContent)this.requestContent;
            if (value instanceof File || value instanceof MultipartContent.Part) {
                MultipartContent multipartContent = new MultipartContent();
                for (XHttpExecutor.KeyValue keyValue : urlencodedContent.params) {
                    multipartContent.part(keyValue.key, keyValue.value);
                }
                this.requestContent = multipartContent;
            } else {
                urlencodedContent.param(key, value, append);
                return this;
            }
        }
        if (!(this.requestContent instanceof MultipartContent)) throw new IllegalStateException(String.format("%s\u4e0d\u80fd\u63a5\u53d7\u952e\u503c\u5bf9\u8bf7\u6c42\u4f53", this.requestContent.getClass().getName()));
        MultipartContent multipartContent = (MultipartContent)this.requestContent;
        if (value instanceof MultipartContent.Part) {
            MultipartContent.Part part = (MultipartContent.Part)value;
            if (!key.equals(part.name)) throw new IllegalArgumentException(String.format("\u53c2\u6570\u7684key\uff1a%s\u4e0e\u8868\u5355\u7684\u540d\u79f0\uff1a%s\u4e0d\u76f8\u7b49", key, part.name));
            multipartContent.part((MultipartContent.Part)value, append);
            return this;
        } else {
            multipartContent.part(key, value, append);
        }
        return this;
    }

    @Nonnull
    public XRequest content(@Nonnull XHttpExecutor.Content content) {
        this.setContent(content);
        return this;
    }

    @Nonnull
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(@Nonnull String charset) {
        this.charset = charset;
    }

    @Override
    @Nonnull
    public String getMethod() {
        return this.requestMethod;
    }

    @Override
    public void setMethod(@Nonnull String method) {
        if (method.equalsIgnoreCase(METHOD_GET) || method.equalsIgnoreCase(METHOD_POST) || method.equalsIgnoreCase(METHOD_DELETE) || method.equalsIgnoreCase(METHOD_PUT)) {
            this.requestMethod = method.toUpperCase();
        }
    }

    @Override
    @Nonnull
    public String getUrl() {
        try {
            if (this.requestQueries != null) {
                return String.format("%s?%s", this.requestUrl, XRequest.kvJoin(this.requestQueries, this.charset));
            }
            return this.requestUrl;
        }
        catch (Exception e) {
            throw new IllegalStateException("\u751f\u6210\u8bf7\u6c42url\u65f6\u51fa\u9519");
        }
    }

    @Override
    public void setUrl(@Nonnull String url) {
        if (!url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
            throw new IllegalArgumentException("XRequest\u4ec5\u652f\u6301HTTP\u534f\u8bae\u548cHTTPS\u534f\u8bae");
        }
        if (url.indexOf(63) >= 0) {
            this.requestUrl = url.substring(0, url.indexOf(63));
            try {
                for (String keyValue : url.substring(url.indexOf(63) + 1).split("&")) {
                    int eqIndex = keyValue.indexOf(61);
                    if (eqIndex < 0) {
                        throw new IllegalArgumentException("\u8bf7\u6c42\u7684url\u683c\u5f0f\u6709\u8bef");
                    }
                    this.query(URLDecoder.decode(keyValue.substring(0, eqIndex), this.charset), URLDecoder.decode(keyValue.substring(eqIndex + 1), this.charset));
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7f16\u7801\u65b9\u5f0f\uff1a%s", this.charset));
            }
        } else {
            this.requestUrl = url;
        }
    }

    @Override
    public void setHeader(@Nonnull String key, @Nullable String value, boolean append) {
        if (this.requestHeaders == null) {
            this.requestHeaders = new LinkedList<XHttpExecutor.KeyValue>();
        }
        if (append) {
            Iterator<XHttpExecutor.KeyValue> iterator = this.requestHeaders.iterator();
            while (iterator.hasNext()) {
                XHttpExecutor.KeyValue keyValue = iterator.next();
                if (!keyValue.key.equals(key)) continue;
                iterator.remove();
            }
        }
        if (value != null) {
            this.requestHeaders.add(new XHttpExecutor.KeyValue(key, value));
        }
    }

    @Override
    @Nullable
    public List<XHttpExecutor.KeyValue> getHeaders() {
        if (this.requestContent != null) {
            try {
                this.header("Content-Type", this.requestContent.contentType(), true);
                long contentLength = this.requestContent.contentLength();
                if (contentLength > 0L) {
                    this.header("Content-Length", String.valueOf(contentLength), true);
                } else {
                    this.header("Transfer-Encoding", "chunked", true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.requestHeaders;
    }

    @Override
    @Nullable
    public XHttpExecutor.Content getContent() {
        return this.requestContent;
    }

    @Override
    public void setContent(@Nonnull XHttpExecutor.Content content) {
        this.requestContent = content;
    }

    public static class FileContent
    implements XHttpExecutor.Content {
        public final File file;

        public FileContent(@Nonnull File file) {
            this.file = file;
        }

        @Override
        @Nonnull
        public String charset() {
            return XTools.cfgDef(XRequest.CFG_REQ_CHARSET, XRequest.CFG_REQ_CHARSET_DEFAULT);
        }

        @Override
        @Nonnull
        public String contentType() throws IOException {
            return Files.probeContentType(Paths.get(this.file.getAbsolutePath(), new String[0]));
        }

        @Override
        public long contentLength() {
            return this.file.length();
        }

        @Override
        public void contentWrite(@Nonnull OutputStream outStream) throws IOException {
            try (FileInputStream finStream = new FileInputStream(this.file);){
                XTools.streamToStream(finStream, outStream);
            }
        }
    }

    public static class StringContent
    implements XHttpExecutor.Content {
        private static Pattern P_CHARSET = Pattern.compile("charset\\s*=\\s*\"?(.+)\"?\\s*;?");
        public final String charset = this.charset();
        public final String mime;
        public final byte[] bytes;

        public StringContent(@Nonnull String mime, @Nonnull String str) {
            try {
                Matcher matcher = P_CHARSET.matcher(mime);
                if (matcher.find()) {
                    this.mime = mime;
                    this.bytes = str.getBytes(matcher.group(1));
                } else {
                    this.mime = mime + "; charset=" + this.charset;
                    this.bytes = str.getBytes(this.charset);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(String.format("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32\u4ee5\u6307\u5b9a\u7684\u7f16\u7801\u65b9\u5f0f\u3010%s\u3011\u8fdb\u884c\u7f16\u7801", this.charset));
            }
        }

        @Override
        @Nonnull
        public String charset() {
            return XTools.cfgDef(XRequest.CFG_REQ_CHARSET, XRequest.CFG_REQ_CHARSET_DEFAULT);
        }

        @Override
        @Nonnull
        public String contentType() {
            return this.mime;
        }

        @Override
        public long contentLength() {
            return this.bytes.length;
        }

        @Override
        public void contentWrite(@Nonnull OutputStream outStream) throws IOException {
            outStream.write(this.bytes);
        }
    }

    public static class MultipartContent
    implements XHttpExecutor.Content {
        public static final String HYPHENS = "--";
        public static final String CRLF = "\r\n";
        private final String charset = this.charset();
        private final List<Part> parts = new LinkedList<Part>();
        private final String boundary = XTools.md5(String.format("multipart-%d-%d", System.currentTimeMillis(), new Random().nextInt()));

        @Nonnull
        public MultipartContent part(@Nonnull String key, @Nullable Object value) {
            return this.part(new Part(key, value, this.charset), false);
        }

        @Nonnull
        public MultipartContent part(@Nonnull String key, @Nullable Object value, boolean clear) {
            return this.part(new Part(key, value, this.charset), clear);
        }

        @Nonnull
        public MultipartContent part(@Nonnull Part part) {
            return this.part(part, false);
        }

        @Nonnull
        public MultipartContent part(@Nonnull Part part, boolean clear) {
            if (clear) {
                Iterator<Part> iterator = this.parts.iterator();
                while (iterator.hasNext()) {
                    Part temp = iterator.next();
                    if (!part.name.equals(temp.name)) continue;
                    iterator.remove();
                }
            }
            if (part.value != null) {
                this.parts.add(part);
            }
            return this;
        }

        @Override
        @Nonnull
        public String charset() {
            return XTools.cfgDef(XRequest.CFG_REQ_CHARSET, XRequest.CFG_REQ_CHARSET_DEFAULT);
        }

        @Override
        @Nonnull
        public String contentType() {
            return "multipart/form-data; boundary=" + this.boundary;
        }

        @Override
        public long contentLength() throws IOException {
            long contentLength = 0L;
            for (Part part : this.parts) {
                contentLength += (long)(HYPHENS + this.boundary + CRLF).getBytes(this.charset).length;
                for (String header : part.headers()) {
                    contentLength += (long)String.format("%s%s", header, CRLF).getBytes(this.charset).length;
                }
                contentLength += (long)CRLF.getBytes(this.charset).length;
                contentLength += part.partLength();
                contentLength += (long)CRLF.getBytes(this.charset).length;
            }
            return contentLength += (long)(HYPHENS + this.boundary + HYPHENS + CRLF).getBytes(this.charset).length;
        }

        @Override
        public void contentWrite(@Nonnull OutputStream outStream) throws IOException {
            for (Part part : this.parts) {
                outStream.write((HYPHENS + this.boundary + CRLF).getBytes(this.charset));
                for (String header : part.headers()) {
                    outStream.write(String.format("%s%s", header, CRLF).getBytes(this.charset));
                }
                outStream.write(CRLF.getBytes(this.charset));
                part.partWrite(outStream);
                outStream.write(CRLF.getBytes(this.charset));
            }
            outStream.write((HYPHENS + this.boundary + HYPHENS + CRLF).getBytes(this.charset));
        }

        public static class Part {
            @Nonnull
            public final String name;
            @Nullable
            public final Object value;
            @Nonnull
            public final String charset;

            public Part(@Nonnull String name, @Nullable Object value) {
                this(name, value, XTools.cfgDef(XRequest.CFG_REQ_CHARSET, XRequest.CFG_REQ_CHARSET_DEFAULT));
            }

            public Part(@Nonnull String name, @Nullable Object value, @Nonnull String charset) {
                this.name = name;
                this.value = value;
                this.charset = charset;
            }

            @Nonnull
            public String[] headers() throws IOException {
                if (this.value instanceof File) {
                    String disposition = String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", this.name, URLEncoder.encode(((File)this.value).getName(), this.charset));
                    String type = String.format("Content-Type: %s", Files.probeContentType(Paths.get(((File)this.value).getAbsolutePath(), new String[0])));
                    return new String[]{disposition, type};
                }
                return new String[]{String.format("Content-Disposition: form-data; name=\"%s\"", this.name)};
            }

            public long partLength() throws IOException {
                if (this.value instanceof File) {
                    return ((File)this.value).length();
                }
                return String.valueOf(this.value).getBytes(this.charset).length;
            }

            public void partWrite(@Nonnull OutputStream outStream) throws IOException {
                if (this.value instanceof File) {
                    try (FileInputStream fiStream = new FileInputStream((File)this.value);){
                        XTools.streamToStream(fiStream, outStream);
                    }
                } else {
                    outStream.write(String.valueOf(this.value).getBytes(this.charset));
                }
            }
        }
    }

    public static class UrlencodedContent
    implements XHttpExecutor.Content {
        private final String charset = this.charset();
        private final List<XHttpExecutor.KeyValue> params = new LinkedList<XHttpExecutor.KeyValue>();
        private byte[] urlencoded;

        @Nonnull
        public UrlencodedContent param(@Nonnull String key, @Nullable Object value) {
            return this.param(key, value, false);
        }

        @Nonnull
        public UrlencodedContent param(@Nonnull String key, @Nullable Object value, boolean clear) {
            this.urlencoded = null;
            if (clear) {
                Iterator<XHttpExecutor.KeyValue> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    XHttpExecutor.KeyValue keyValue = iterator.next();
                    if (!keyValue.key.equals(key)) continue;
                    iterator.remove();
                }
            }
            if (value != null) {
                this.params.add(new XHttpExecutor.KeyValue(key, value));
            }
            return this;
        }

        @Override
        @Nonnull
        public String charset() {
            return XTools.cfgDef(XRequest.CFG_REQ_CHARSET, XRequest.CFG_REQ_CHARSET_DEFAULT);
        }

        @Override
        @Nonnull
        public String contentType() {
            return "application/x-www-form-urlencoded; charset=" + this.charset;
        }

        @Override
        public long contentLength() throws IOException {
            if (this.urlencoded == null) {
                this.urlencoded = XRequest.kvJoin(this.params, this.charset).getBytes(this.charset);
            }
            return this.urlencoded.length;
        }

        @Override
        public void contentWrite(@Nonnull OutputStream outStream) throws IOException {
            if (this.urlencoded == null) {
                this.urlencoded = XRequest.kvJoin(this.params, this.charset).getBytes(this.charset);
            }
            outStream.write(this.urlencoded);
        }
    }
}

